/*
 *  Linux Frame Buffer Device Configuration
 *
 *   Copyright 1995-1998 by Geert Uytterhoeven
 *		       (Geert.Uytterhoeven@cs.kuleuven.ac.be)
 *
 *  --------------------------------------------------------------------------
 *
 *  This file is subject to the terms and conditions of the GNU General Public
 *  License. See the file COPYING in the main directory of the Linux
 *  distribution for more details.
 */
 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) previous_year-2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * </DOC_AMD_STD>
  * 
  */


%{

#define YYSTYPE		long

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fb.h"
#include "tvoset.h"

extern int yylex(void);
extern void yyerror(const char *s);
extern int line;


static struct VideoMode VideoMode;

static void ClearVideoMode(void)
{
    memset(&VideoMode, 0, sizeof(VideoMode));
    VideoMode.accel_flags = FB_ACCELF_TEXT;
}

%}

%start file

%token MODE GEOMETRY TIMINGS HSYNC VSYNC CSYNC GSYNC EXTSYNC BCAST LACED DOUBLE
       RGBA NONSTD ACCEL GRAYSCALE
       ENDMODE POLARITY BOOLEAN STRING NUMBER 

%%

file	  : vmodes
	  ;


vmodes	  : /* empty */
	  | vmodes vmode
	  ;

vmode	  : MODE STRING geometry timings options ENDMODE
	    {
		VideoMode.name = (const char *)$2;
		AddVideoMode(&VideoMode);
		ClearVideoMode();
	    }
	  ;

geometry  : GEOMETRY NUMBER NUMBER NUMBER NUMBER NUMBER
	    {
		ClearVideoMode();
		VideoMode.xres = $2;
		VideoMode.yres = $3;
		VideoMode.vxres = $4;
		VideoMode.vyres = $5;
		VideoMode.depth = $6;
	    }
	  ;

timings	  : TIMINGS NUMBER NUMBER NUMBER NUMBER NUMBER NUMBER NUMBER
	    {
		VideoMode.pixclock = $2;
		VideoMode.left = $3;
		VideoMode.right = $4;
		VideoMode.upper = $5;
		VideoMode.lower = $6;
		VideoMode.hslen = $7;
		VideoMode.vslen = $8;
	    }
	  ;

options	  : /* empty */
	  | options hsync
	  | options vsync
	  | options csync
	  | options gsync
	  | options extsync
	  | options bcast
	  | options laced
	  | options double
	  | options rgba
	  | options nonstd
	  | options accel
	  | options grayscale
	  ;

hsync	  : HSYNC POLARITY
	    {
		VideoMode.hsync = $2;
	    }
	  ;

vsync	  : VSYNC POLARITY
	    {
		VideoMode.vsync = $2;
	    }
	  ;

csync	  : CSYNC POLARITY
	    {
		VideoMode.csync = $2;
	    }
	  ;

gsync	  : GSYNC POLARITY
	    {
		VideoMode.gsync = $2;
	    }
	  ;

extsync	  : EXTSYNC BOOLEAN
	    {
		VideoMode.extsync = $2;
	    }
	  ;

bcast	  : BCAST BOOLEAN
	    {
		VideoMode.bcast = $2;
	    }
	  ;

laced	  : LACED BOOLEAN
	    {
		VideoMode.laced = $2;
	    }
	  ;

double	  : DOUBLE BOOLEAN
	    {
		VideoMode.dblscan = $2;
	    }
	  ;

rgba      : RGBA STRING
            {
		makeRGBA(&VideoMode, (const char*)$2);
	    }
	  ;

nonstd    : NONSTD NUMBER
            {
	    	VideoMode.nonstd = $2;
	    }
	  ;

accel	  : ACCEL BOOLEAN
	    {
		VideoMode.accel_flags = $2;
	    }
	  ;

grayscale : GRAYSCALE BOOLEAN
	    {
		VideoMode.grayscale = $2;
	    }
	  ;
	  
%%
