
/*
 *  Linux Frame Buffer Device Configuration
 *
 *   Copyright 1995-1998 by Geert Uytterhoeven
 *		       (Geert.Uytterhoeven@cs.kuleuven.ac.be)
 *
 *  --------------------------------------------------------------------------
 *
 *  This file is subject to the terms and conditions of the GNU General Public
 *  License. See the file COPYING in the main directory of the Linux
 *  distribution for more details.
 */
 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) previous_year-2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * </DOC_AMD_STD>
  * 
  */


%{

#define YYSTYPE		long

#include <string.h>
#include <stdlib.h>

#include "tvoset.h"
#include "modes.tab.h"

struct keyword {
    const char *name;
    int token;
    int value;
};

static struct keyword keywords[] = {
    { "mode", MODE, 0 },
    { "geometry", GEOMETRY, 0 },
    { "timings", TIMINGS, 0 },
    { "hsync", HSYNC, 0 },
    { "vsync", VSYNC, 0 },
    { "csync", CSYNC, 0 },
    { "gsync", GSYNC, 0 },
    { "extsync", EXTSYNC, 0 },
    { "bcast", BCAST, 0 },
    { "laced", LACED, 0 },
    { "double", DOUBLE, 0 },
    { "rgba", RGBA, 0 },
    { "nonstd", NONSTD, 0 },
    { "accel", ACCEL, 0 },
    { "grayscale", GRAYSCALE, 0 },
    { "endmode", ENDMODE, 0 },
    { "low", POLARITY, LOW },
    { "high", POLARITY, HIGH },
    { "false", BOOLEAN, FALSE },
    { "true", BOOLEAN, TRUE },
    { "", -1, 0 }
};

int line = 1;


void yyerror(const char *s)
{
    Die("%s:%d: %s\n", Opt_modedb, line, s);
}


int yywrap(void)
{
    return 1;
}


static int FindToken(const char *s)
{
    int i;

    for (i = 0; keywords[i].token > 0; i++)
	if (!strcasecmp(s, keywords[i].name)) {
	    yylval = keywords[i].value;
	    return keywords[i].token;
	}
    Die("%s:%d: Unknown keyword `%s'\n", Opt_modedb, line, s);
}


static const char *CopyString(const char *s)
{
    int len;
    char *s2;

    len = strlen(s)-2;
    if (!(s2 = malloc(len+1)))
	Die("No memory\n");
    strncpy(s2, s+1, len);
    s2[len] = '\0';
    return s2;
}


%}

keyword	[a-zA-Z][a-zA-Z0-9]*
number	[0-9]*
string	\"[^\"\n]*\"
comment	\#([^\n]*)
space	[ \t]+
junk	.

%%

{keyword}   {
		return FindToken(yytext);
	    }

{number}    {
		yylval = strtoul(yytext, NULL, 0);
		return NUMBER;
	    }

{string}    {
		yylval = (unsigned long)CopyString(yytext);
		return STRING;
	    }

{comment}$  break;

{space}	    break;

\n	    {
		line++;
		break;
	    }

{junk}	    {
		Die("%s:%d: Invalid token `%s'\n", Opt_modedb, line, yytext);
	    }

%%
