 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) 2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * File Contents:   This file contains definitions of the Geode 
  *                  frame buffer panel data structures.
  *
  * SubModule:       Geode FlatPanel library
  * </DOC_AMD_STD>
  * 
  */


#ifndef _pnl_defs_h
#define _pnl_defs_h

typedef enum
{
   MARMOT_PLATFORM = 0,
   UNICORN_PLATFORM,
   CENTAURUS_PLATFORM,
   ARIES_PLATFORM,
   CARMEL_PLATFORM,
   HYDRA_PLATFORM,
   DORADO_PLATFORM,
   DRACO_PLATFORM,
   REDCLOUD_PLATFORM,
   OTHER_PLATFORM
}
SYS_BOARD;

#define PNL_9210             0x01
#define PNL_9211_A           0x02
#define PNL_9211_C           0x04
#define PNL_UNKNOWN_CHIP     0x08

#define PNL_TFT              0x01
#define PNL_SSTN             0x02
#define PNL_DSTN             0x04
#define PNL_TWOP             0x08
#define PNL_UNKNOWN_PANEL    0x10

#define PNL_MONO_PANEL       0x01
#define PNL_COLOR_PANEL      0x02
#define PNL_UNKNOWN_COLOR    0x08

#define PNL_PANELPRESENT     0x01
#define PNL_PLATFORM         0x02
#define PNL_PANELCHIP        0x04
#define PNL_PANELSTAT        0x08
#define PNL_OVERRIDE_STAT    0x10
#define PNL_OVERRIDE_ALL     0x1F

typedef struct _Pnl_PanelStat_
{
   int Type;
   int XRes;
   int YRes;
   int Depth;
   int MonoColor;
}
Pnl_PanelStat;

typedef struct _Pnl_Params_
{
   unsigned long Flags;
   int PanelPresent;
   int Platform;
   int PanelChip;
   Pnl_PanelStat PanelStat;
}
Pnl_PanelParams, *PPnl_PanelParams;

#endif /* _pnl_defs_h */

/* END OF FILE */
