 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) 2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * File Contents: This file contains the Geode frame buffer panel 
  *                functions prototypes and it includes panel 
  *                definitions	header file.
  *
  * SubModule:     Geode FlatPanel library
  * </DOC_AMD_STD>
  * 
  */


/* COMPILER OPTION FOR C++ PROGRAMS */

#ifndef _panel_h
#define _panel_h

#include "pnl_defs.h"

#ifdef __cplusplus
extern "C"
{
#endif

/* CLOSE BRACKET FOR C++ COMPLILATION */

   void Pnl_SetPlatform(int platform);
   int Pnl_GetPlatform(void);
   int Pnl_IsPanelPresent(void);
   void Pnl_SetPanelPresent(int present);
   void Pnl_SetPanelChip(int panelChip);
   int Pnl_GetPanelChip(void);
   void Pnl_SetPanelParam(PPnl_PanelParams pParam);
   void Pnl_GetPanelParam(PPnl_PanelParams pParam);
   int Pnl_InitPanel(PPnl_PanelParams pParam);
   int Detect_Platform(void);
   void Pnl_SavePanelState(void);
   void Pnl_RestorePanelState(void);
   void Pnl_PowerUp(void);
   void Pnl_PowerDown(void);

   int Pnl_IsPanelEnabledInBIOS(void);
   void Pnl_GetPanelInfoFromBIOS(int *xres, int *yres, int *bpp, int *hz);
/* from durango */

#if defined(_WIN32) /* windows */
   extern void gfx_delay_milliseconds(unsigned long milliseconds);
   extern unsigned long gfx_ind(unsigned short port);
   extern void gfx_outd(unsigned short port, unsigned long data);
   extern unsigned char gfx_inb(unsigned short port);
   extern void gfx_outb(unsigned short port, unsigned char data);
#endif

#ifdef __cplusplus
}
#endif

#endif /* !_panel_h */

/* END OF FILE */
