 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) 2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * File Contents: This file contailns the panel include files and 
  *                external pointer to the hardware.
  *
  * Project:       Geode Frame buffer device driver
  * </DOC_AMD_STD>
  * 
  */


#include <linux/config.h>

#ifdef CONFIG_FB_NSC_FP
#if defined(linux)                      /* Linux */

#ifdef __KERNEL__

#include <linux/string.h>
#include <asm/io.h>

#else

#include <linux/fs.h>
#include <asm/mman.h>

#endif /* __KERNEL__ */
#elif defined(_WIN32)                   /* windows */

#include <windows.h>

#endif

#include "panel.h"
#include "gfx_defs.h"
#include "gfx_rtns.h"
extern unsigned char *gfx_virt_regptr;
extern unsigned char *gfx_virt_fbptr;
extern unsigned char *gfx_virt_vidptr;
extern unsigned char *gfx_virt_vipptr;
extern unsigned long gfx_detect_video(void);
extern unsigned char gfx_inb(unsigned short port);
extern unsigned short gfx_inw(unsigned short port);
extern unsigned long gfx_ind(unsigned short port);
extern void gfx_outb(unsigned short port, unsigned char data);
extern void gfx_outw(unsigned short port, unsigned short data);
extern void gfx_outd(unsigned short port, unsigned long data);

#define PLATFORM_DYNAMIC                1       /* runtime selection */
#define PLATFORM_DRACO                  0       /* Draco + 9210 */
#define PLATFORM_CENTAURUS              1       /* Centaurus + 9211 RevA */
#define PLATFORM_DORADO                 1       /* Dorado + 9211 RevC */
#define PLATFORM_GX2BASED               1       /* GX2 had 9211 embeded */

unsigned char *XpressROMPtr;

#include "pnl_init.c"
#include "pnl_bios.c"
#endif
