 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) 2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * File Contents: This file contains the main functions for power management.
  *                The fnctions Save/Restore the h/w registers.
  *
  * Project:       Geode Frame buffer device driver
  * </DOC_AMD_STD>
  * 
  */


#ifndef _NSC_SAVREG_H_
#define _NSC_SAVREG_H_

/* data structure to hold 8100 to 8214 */
#define SAVREG_GX1_GP_START 0x8100
#define SAVREG_GX1_GP_END   0x8214
#define SAVREG_GX1_GP_NUM   ((SAVREG_GX1_GP_END - SAVREG_GX1_GP_START) >> 2)
typedef struct
{
   unsigned int reg[SAVREG_GX1_GP_NUM + 1];
}
SAV_REG_GX1_GP;

/* data structure to hold 8304 to 837C */
#define SAVREG_GX1_DP_START 0x8304
#define SAVREG_GX1_DP_END   0x837C
#define SAVREG_GX1_DP_NUM   ((SAVREG_GX1_DP_END - SAVREG_GX1_DP_START) >> 2)
typedef struct
{
   unsigned int reg[SAVREG_GX1_DP_NUM + 1];
   unsigned int palette[256];
}
SAV_REG_GX1_DP;

/* data structure to hold Graphics registers og 5530: offset 0 to 18 */
#define SAVREG_5530_START       0x00
#define SAVREG_5530_END         0x80
#define SAVREG_5530_NUM         ((SAVREG_5530_END - SAVREG_5530_START) >> 2 )

typedef struct
{
   unsigned int reg[SAVREG_5530_NUM + 1];
}
SAV_REG_5530;

#define REG_SAVE 1
#define REG_RESTORE 2
#define REG_DEBUG 0
/* Function prototypes */

unsigned long GX1SaveRestoreGPReg(unsigned int SaveOrRestore,
                                 SAV_REG_GX1_GP * Reg);
unsigned long GX1SaveRestoreDPReg(unsigned int SaveOrRestore,
                                 SAV_REG_GX1_DP * Reg);
unsigned long GX1SaveRestore5530Reg(unsigned int SaveOrRestore,
                                   SAV_REG_5530 * Reg);

/* data structure to hold C000 to C050 */
#define SAVREG_GX2_GP_START 0xC000
#define SAVREG_GX2_GP_END   0xC050
#define SAVREG_GX2_GP_NUM   ((SAVREG_GX2_GP_END - SAVREG_GX2_GP_START) >> 2)
typedef struct
{
   unsigned int reg[SAVREG_GX2_GP_NUM + 1];
}
SAV_REG_GX2_GP;

/* data structure to hold 8000 to 8090 */
#define SAVREG_GX2_DP_START 0x8004
#define SAVREG_GX2_DP_END   0x8090
#define SAVREG_GX2_DP_NUM   ((SAVREG_GX2_DP_END - SAVREG_GX2_DP_START) >> 2)
typedef struct
{
   unsigned int reg[SAVREG_GX2_DP_NUM + 1]; 
   unsigned int palette[256];
}
SAV_REG_GX2_DP;

/* data structure to hold C000 to C414 */
#define SAVREG_GX2_DF_START 0x4000
#define SAVREG_GX2_DF_END   0x4414
#define SAVREG_GX2_DF_NUM   ((SAVREG_GX2_DF_END - SAVREG_GX2_DF_START) >> 2)
typedef struct
{
   unsigned int reg[SAVREG_GX2_DF_NUM + 1];
}
SAV_REG_GX2_DF;


unsigned long GX2SaveRestoreGPReg(unsigned int SaveOrRestore,
                                 SAV_REG_GX2_GP * Reg);
unsigned long GX2SaveRestoreDPReg(unsigned int SaveOrRestore,
                                 SAV_REG_GX2_DP * Reg);
unsigned long GX2SaveRestoreDFReg(unsigned int SaveOrRestore,
                                 SAV_REG_GX2_DF * Reg);
#endif
