 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) 2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * File Contents: This file contains the main functions for power management.
  *                The fnctions Save/Restore the h/w registers.
  *
  * Project:       Geode Frame buffer device driver
  * </DOC_AMD_STD>
  * 
  */


#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/version.h>
#include "gfx_regs.h"
#include "gfx_defs.h"
#include "gfx_rtns.h"
#include "nsc_savreg.h"
#define TESTREAD 0

unsigned long
GX1SaveRestoreGPReg(unsigned int saveOrRestore, SAV_REG_GX1_GP * Reg)
{
   unsigned int count, offset;

   /* Start to copy. */
   for (count = 0, offset = SAVREG_GX1_GP_START;
        count <= SAVREG_GX1_GP_NUM; count++, offset += 4) {
      if (saveOrRestore == REG_DEBUG) {
         printk(KERN_INFO "0x%X = 0x%X\n", offset, Reg->reg[count]);
      } else if (saveOrRestore == REG_SAVE) {
         /* Save */
         Reg->reg[count] = READ_REG32(offset);
      } else if (saveOrRestore == REG_RESTORE) {
         /* Restore */
         WRITE_REG32(offset, Reg->reg[count]);
      }
   }
   return 1;
}

unsigned long
GX1SaveRestoreDPReg(unsigned int saveOrRestore, SAV_REG_GX1_DP * Reg)
{
   unsigned int count, offset;

   unsigned int savUnlock;

   /* Save conetents of the Unlock reg */
   savUnlock = READ_REG32(DC_UNLOCK);

   /* Unlock before copying */
   WRITE_REG32(DC_UNLOCK, 0x4758);

   /*  Start to copy. */
   for (count = 0, offset = SAVREG_GX1_DP_START;
        count <= SAVREG_GX1_DP_NUM; count++, offset += 4) {
      if (saveOrRestore == REG_DEBUG) {
         printk(KERN_INFO "0x%X = 0x%X\n", offset, Reg->reg[count]);
      } else if (saveOrRestore == REG_SAVE) {
         /* Save */
         Reg->reg[count] = READ_REG32(offset);
      } else if (saveOrRestore == REG_RESTORE) {
         /* Restore */
         WRITE_REG32(offset, Reg->reg[count]);
      }
   }

   /* handle palette */
   WRITE_REG32(DC_PAL_ADDRESS, 0);
   for (count = 0; count < 256; count++) {
      if (saveOrRestore == REG_SAVE) {
         Reg->palette[count] = READ_REG32(DC_PAL_DATA);
      } else if (saveOrRestore == REG_RESTORE) {
         WRITE_REG32(DC_PAL_DATA, Reg->palette[count]);
      }
   }
   /* Restore the conetents of the Unlock reg */
   WRITE_REG32(DC_UNLOCK, savUnlock);

   return 1;
}

unsigned long
GX1SaveRestore5530Reg(unsigned int saveOrRestore, SAV_REG_5530 * Reg)
{
   unsigned int count, offset;

   /*  Start to copy. */
   /* Start to copy. */
   for (count = 0, offset = SAVREG_5530_START;
        count <= SAVREG_5530_NUM; count++, offset += 4) {
      if (saveOrRestore == REG_DEBUG) {
         printk(KERN_INFO "0x%X = 0x%X\n", offset, Reg->reg[count]);
      } else if (saveOrRestore == REG_SAVE) {
         /* Save */
         Reg->reg[count] = READ_VID32(offset);
      } else if (saveOrRestore == REG_RESTORE) {
         /* Restore */
         WRITE_VID32(offset, Reg->reg[count]);
      }
   }

   return 1;
}

/****************************GX2*************************************/
unsigned long
GX2SaveRestoreGPReg(unsigned int saveOrRestore, SAV_REG_GX2_GP * Reg)
{
   unsigned int count, offset;

   /* Start to copy. */
   for (count = 0, offset = SAVREG_GX2_GP_START;
        count <= SAVREG_GX2_GP_NUM; count++, offset += 4) {
      if (saveOrRestore == REG_DEBUG) {
         printk(KERN_INFO "0x%X = 0x%X\n", offset, Reg->reg[count]);
      } else if (saveOrRestore == REG_SAVE) {
         /* Save */
         Reg->reg[count] = READ_REG32(offset);
      } else if (saveOrRestore == REG_RESTORE) {
         /* Restore */
         WRITE_REG32(offset, Reg->reg[count]);
      }
   }
   return 1;
}

unsigned long
GX2SaveRestoreDPReg(unsigned int saveOrRestore, SAV_REG_GX2_DP * Reg)
{
   unsigned int count, offset;

   unsigned int savUnlock;

   /* Save conetents of the Unlock reg */
   savUnlock = READ_REG32(DC_UNLOCK);

   /* Unlock before copying */
   WRITE_REG32(DC_UNLOCK, 0x4758);

   /*  Start to copy. */
   for (count = 0, offset = SAVREG_GX2_DP_START;
        count <= SAVREG_GX2_DP_NUM; count++, offset += 4) {
      if (saveOrRestore == REG_DEBUG) {
         printk(KERN_INFO "0x%X = 0x%X\n", offset, Reg->reg[count]);
      } else if (saveOrRestore == REG_SAVE) {
         /* Save */
         Reg->reg[count] = READ_REG32(offset);
      } else if (saveOrRestore == REG_RESTORE) {
         /* Restore */
         WRITE_REG32(offset, Reg->reg[count]);
      }
   }

   /* handle palette */
   WRITE_REG32(DC_PAL_ADDRESS, 0);
   for (count = 0; count < 256; count++) {
      if (saveOrRestore == REG_SAVE) {
         Reg->palette[count] = READ_REG32(DC_PAL_DATA);
      } else if (saveOrRestore == REG_RESTORE) {
         WRITE_REG32(DC_PAL_DATA, Reg->palette[count]);
      }
   }
   /* Restore the conetents of the Unlock reg */
   WRITE_REG32(DC_UNLOCK, savUnlock);

   return 1;
}

unsigned long
GX2SaveRestoreDFReg(unsigned int saveOrRestore, SAV_REG_GX2_DF* Reg)
{
   unsigned int count, offset;

   /* Start to copy. */
   for (count = 0, offset = SAVREG_GX2_DF_START;
        count <= SAVREG_GX2_DF_NUM; count++, offset += 4) {
      if (saveOrRestore == REG_DEBUG) {
         printk(KERN_INFO "0x%X = 0x%X\n", offset, Reg->reg[count]);
      } else if (saveOrRestore == REG_SAVE) {
         /* Save */
         Reg->reg[count] = READ_VID32(offset);
      } else if (saveOrRestore == REG_RESTORE) {
         /* Restore */
         WRITE_VID32(offset, Reg->reg[count]);
      }
   }
   return 1;
}

