 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) 2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * This is the main file used to add Durango graphics support to a software 
  * project.  The main reason to have a single file include the other files
  * is that it centralizes the location of the compiler options.  This file
  * should be tuned for a specific implementation, and then modified as needed
  * for new Durango releases.  The releases.txt file indicates any updates to
  * this main file, such as a new definition for a new hardware platform. 
  *
  * In other words, this file should be copied from the Durango source files
  * once when a software project starts, and then maintained as necessary.  
  * It should not be recopied with new versions of Durango unless the 
  * developer is willing to tune the file again for the specific project.
  * </DOC_AMD_STD>
  * 
  */


unsigned int GetVideoMemSize(void);

/* ROUTINES added accessing hardware reg */
void
gfx_write_reg_8(unsigned long offset, unsigned char value)
{
   WRITE_REG8(offset, value);
}

void
gfx_write_reg_16(unsigned long offset, unsigned short value)
{
   WRITE_REG16(offset, value);
}

void
gfx_write_reg_32(unsigned long offset, unsigned long value)
{
   WRITE_REG32(offset, value);
}
unsigned short
gfx_read_reg_16(unsigned long offset)
{
   unsigned short value;

   value = READ_REG16(offset);
   return value;
}
unsigned long
gfx_read_reg_32(unsigned long offset)
{
   unsigned long value;

   value = READ_REG32(offset);
   return value;
}

void
gfx_write_vid_32(unsigned long offset, unsigned long value)
{
   WRITE_VID32(offset, value);
}
unsigned long
gfx_read_vid_32(unsigned long offset)
{
   unsigned long value;

   value = READ_VID32(offset);
   return value;
}

/*Addition for the VIP code */
unsigned long
gfx_read_vip_32(unsigned long offset)
{
   unsigned long value;

   value = READ_VIP32(offset);
   return value;
}

void
gfx_write_vip_32(unsigned long offset, unsigned long value)
{
   WRITE_VIP32(offset, value);
}

unsigned int
GetVideoMemSize(void)
{
   unsigned int graphicsMemBaseAddr;
   unsigned int totalMem = 0;
   int i;
   unsigned int graphicsMemMask, graphicsMemShift;

   /* Read graphics base address. */

   graphicsMemBaseAddr = gfx_read_reg_32(0x8414);

   if (1) {
      unsigned int mcBankCfg = gfx_read_reg_32(0x8408);
      unsigned int dimmShift = 4;

      graphicsMemMask = 0x7FF;
      graphicsMemShift = 19;

      /* Calculate total memory size for GXm. */

      for (i = 0; i < 2; i++) {
         if (((mcBankCfg >> dimmShift) & 0x7) != 0x7) {
            switch ((mcBankCfg >> (dimmShift + 4)) & 0x7) {
            case 0:
               totalMem += 0x400000;
               break;
            case 1:
               totalMem += 0x800000;
               break;
            case 2:
               totalMem += 0x1000000;
               break;
            case 3:
               totalMem += 0x2000000;
               break;
            case 4:
               totalMem += 0x4000000;
               break;
            case 5:
               totalMem += 0x8000000;
               break;
            case 6:
               totalMem += 0x10000000;
               break;
            case 7:
               totalMem += 0x20000000;
               break;
            default:
               break;
            }
         }
         dimmShift += 16;
      }
   } else {
      unsigned int mcMemCntrl1 = gfx_read_reg_32(0x8400);
      unsigned int bankSizeShift = 12;

      graphicsMemMask = 0x3FF;
      graphicsMemShift = 17;

      /* Calculate total memory size for GX. */

      for (i = 0; i < 4; i++) {
         switch ((mcMemCntrl1 >> bankSizeShift) & 0x7) {
         case 1:
            totalMem += 0x200000;
            break;
         case 2:
            totalMem += 0x400000;
            break;
         case 3:
            totalMem += 0x800000;
            break;
         case 4:
            totalMem += 0x1000000;
            break;
         case 5:
            totalMem += 0x2000000;
            break;
         default:
            break;
         }
         bankSizeShift += 3;
      }
   }

   /* Calculate graphics memory base address */

   graphicsMemBaseAddr &= graphicsMemMask;
   graphicsMemBaseAddr <<= graphicsMemShift;

   return (totalMem - graphicsMemBaseAddr);
}

/* END OF FILE */
