 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) 2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * File Contents: This file contains the  the Geode frame buffer
  *                device driver specific ioctl functions prototypes.
  *                All the geode frame buffer driver ioctl functions
  *                uses the durango library to access the hardware.
  *
  * Project:       Geode Frame buffer device driver
  * </DOC_AMD_STD>
  * 
  */

#ifndef __GEODEIOCTL_H_SEP_20
#define __GEODEIOCTL_H_SEP_20

#define FUNC(x)  (((int (*)(void *)) (x))
#define CONFIG_FB_GEODE_GX2

typedef struct _NSC_IOCTL_TABLE_
{
   int (*func) (PGAL_BASE arg);
   int inbytes;
   int outbytes;
}
IOCTL_TABLE;

int geodefb_ioctl_ext(struct inode *inode,
                      struct file *file,
                      u_int cmd, u_long arg, int con, struct fb_info *info);

void Init_Dispatch_Table(void);

int Nscgfxfn_Unsupported(PGAL_BASE arg);
int Nscgfxfn_getadapterinfo(PGAL_BASE arg);
int Nscgfxfn_setsoftvgastate(PGAL_BASE arg);
int Nscgfxfn_getsoftvgastate(PGAL_BASE arg);
int Nscgfxfn_vgatestpci(PGAL_BASE arg);
int Nscgfxfn_vgagetpcicommand(PGAL_BASE arg);
int Nscgfxfn_vgaseqreset(PGAL_BASE arg);
int Nscgfxfn_vgasetgraphicsbits(PGAL_BASE arg);
int Nscgfxfn_setcrtenable(PGAL_BASE arg);
int Nscgfxfn_waituntilidle(PGAL_BASE arg);
int Nscgfxfn_waitverticalblank(PGAL_BASE arg);
int Nscgfxfn_writereg(PGAL_BASE arg);
int Nscgfxfn_readreg(PGAL_BASE arg);
int Nscgfxfn_ismodesupported(PGAL_BASE arg);
int Nscgfxfn_setdisplaymode(PGAL_BASE arg);
int Nscgfxfn_getdisplaymode(PGAL_BASE arg);
int Nscgfxfn_setbpp(PGAL_BASE arg);
int Nscgfxfn_setdisplaybpp(PGAL_BASE arg);
int Nscgfxfn_getdisplaybpp(PGAL_BASE arg);
int Nscgfxfn_setdisplaypitch(PGAL_BASE arg);
int Nscgfxfn_getdisplaypitch(PGAL_BASE arg);
int Nscgfxfn_setdisplayoffset(PGAL_BASE arg);
int Nscgfxfn_getdisplayoffset(PGAL_BASE arg);
int Nscgfxfn_getrefreshfromdotclock(PGAL_BASE arg);
int Nscgfxfn_getdisplaytiming(PGAL_BASE arg);
int Nscgfxfn_setdisplaytiming(PGAL_BASE arg);
int Nscgfxfn_setfixedtimings(PGAL_BASE arg);
int Nscgfxfn_setdisplaypaletteentry(PGAL_BASE arg);
int Nscgfxfn_getdisplaypaletteentry(PGAL_BASE arg);
int Nscgfxfn_setdisplaypalette(PGAL_BASE arg);
int Nscgfxfn_getdisplaypalette(PGAL_BASE arg);
int Nscgfxfn_setcompressionstate(PGAL_BASE arg);
int Nscgfxfn_getcompressionstate(PGAL_BASE arg);
int Nscgfxfn_setcompressionparams(PGAL_BASE arg);
int Nscgfxfn_getcompressionparams(PGAL_BASE arg);
int Nscgfxfn_setcursorenable(PGAL_BASE arg);
int Nscgfxfn_getcursorenable(PGAL_BASE arg);
int Nscgfxfn_setcursorcolors(PGAL_BASE arg);
int Nscgfxfn_getcursorcolors(PGAL_BASE arg);
int Nscgfxfn_setcursorposition(PGAL_BASE arg);
int Nscgfxfn_getcursorposition(PGAL_BASE arg);
int Nscgfxfn_setcursorshape32(PGAL_BASE arg);
int Nscgfxfn_setcursorshape64(PGAL_BASE arg);
int Nscgfxfn_setsolidpattern(PGAL_BASE arg);
int Nscgfxfn_setsolidsource(PGAL_BASE arg);
int Nscgfxfn_setmonosource(PGAL_BASE arg);
int Nscgfxfn_setmonopattern(PGAL_BASE arg);
int Nscgfxfn_setrasteroperation(PGAL_BASE arg);
int Nscgfxfn_patternfill(PGAL_BASE arg);
int Nscgfxfn_screentoscreenblt(PGAL_BASE arg);
int Nscgfxfn_screentoscreenxblt(PGAL_BASE arg);
int Nscgfxfn_bresenhamline(PGAL_BASE arg);
int Nscgfxfn_color_pattern_fill(PGAL_BASE arg);
int Nscgfxfn_color_bitmap_to_screen_blt(PGAL_BASE arg);
int Nscgfxfn_color_bitmap_to_screen_xblt(PGAL_BASE arg);
int Nscgfxfn_mono_bitmap_to_screen_blt(PGAL_BASE arg);
int Nscgfxfn_text_blt(PGAL_BASE arg);
int Nscgfxfn_vgamodeswitch(PGAL_BASE arg);
int Nscgfxfn_vgaclearextended(PGAL_BASE arg);
int Nscgfxfn_vgapitch(PGAL_BASE arg);
int Nscgfxfn_vgarestore(PGAL_BASE arg);
int Nscgfxfn_vgasave(PGAL_BASE arg);
int Nscgfxfn_vgamode(PGAL_BASE arg);
int Nscpnlfn_enabledinbios(PGAL_BASE arg);
int Nscpnlfn_infofrombios(PGAL_BASE arg);
int Nscpnlfn_setpanelparams(PGAL_BASE arg);
int Nscpnlfn_getpanelparams(PGAL_BASE arg);
int Nscpnlfn_initpanel(PGAL_BASE arg);
int Nscpnlfn_savepanel(PGAL_BASE arg);
int Nscpnlfn_restorepanel(PGAL_BASE arg);
int Nscpnlfn_powerup(PGAL_BASE arg);
int Nscpnlfn_powerdown(PGAL_BASE arg);
int Nscenable_panning(PGAL_BASE arg);
int Nscgfxfn_settvparams(PGAL_BASE arg);
int Nscgfxfn_gettvparams(PGAL_BASE arg);
int Nscgfxfn_settvtiming(PGAL_BASE arg);
int Nscgfxfn_gettvtiming(PGAL_BASE arg);
int Nscgfxfn_settvenable(PGAL_BASE arg);
int Nscgfxfn_gettvenable(PGAL_BASE arg);
int Nscgfxfn_istvmodesupported(PGAL_BASE arg);
int Nscgfxfn_setvideoenable(PGAL_BASE arg);
int Nscgfxfn_setvideoformat(PGAL_BASE arg);
int Nscgfxfn_setvideosize(PGAL_BASE arg);
int Nscgfxfn_setvideooffset(PGAL_BASE arg);
int Nscgfxfn_setvideoyuvoffsets(PGAL_BASE arg);
int Nscgfxfn_setvideoyuvpitch(PGAL_BASE arg);
int Nscgfxfn_getvideoyuvpitch(PGAL_BASE arg);
int Nscgfxfn_setvideowindow(PGAL_BASE arg);
int Nscgfxfn_setvideoscale(PGAL_BASE arg);
int Nscgfxfn_setvideofilter(PGAL_BASE arg);
int Nscgfxfn_setvideocolorkey(PGAL_BASE arg);
int Nscgfxfn_setvideodownscale_enable(PGAL_BASE arg);
int Nscgfxfn_setvideodownscale_config(PGAL_BASE arg);
int Nscgfxfn_setvideodownscale_coefficients(PGAL_BASE arg);
int Nscgfxfn_setvideosource(PGAL_BASE arg);
int Nscgfxfn_setvideointerlaced(PGAL_BASE arg);
int Nscgfxfn_getvideointerlaced(PGAL_BASE arg);
int Nscgfxfn_setcolorspaceYUV(PGAL_BASE arg);
int Nscgfxfn_getcolorspaceYUV(PGAL_BASE arg);
int Nscgfxfn_setvideocursor(PGAL_BASE arg);
int Nscgfxfn_getvideocursor(PGAL_BASE arg);
int Nscgfxfn_setvideorequest(PGAL_BASE arg);
int Nscgfxfn_setalphaenable(PGAL_BASE arg);
int Nscgfxfn_getalphaenable(PGAL_BASE arg);
int Nscgfxfn_setalphawindow(PGAL_BASE arg);
int Nscgfxfn_setalphavalue(PGAL_BASE arg);
int Nscgfxfn_setalphapriority(PGAL_BASE arg);
int Nscgfxfn_setalphacolor(PGAL_BASE arg);
int Nscgfxfn_setalpharegion(PGAL_BASE arg);
int Nscgfxfn_setvideooutsidealpha(PGAL_BASE arg);
int Nscgfxfn_setvideopalette(PGAL_BASE arg);
int Nscgfxfn_getvideoinfo(PGAL_BASE arg);
int Nscgfxfn_setvipenable(PGAL_BASE arg);
int Nscgfxfn_getvipenable(PGAL_BASE arg);
int Nscgfxfn_setdestinationstride(PGAL_BASE arg);
int Nscgfxfn_setvipcapturerunmode(PGAL_BASE arg);
int Nscgfxfn_setsourcetransparency(PGAL_BASE arg);
int Nscgfxfn_setpatternorigin(PGAL_BASE arg);
int Nscgfxfn_setvippitch(PGAL_BASE arg);
int Nscgfxfn_getvippitch(PGAL_BASE arg);
int Nscgfxfn_setvipmode(PGAL_BASE arg);
int Nscgfxfn_getvipmode(PGAL_BASE arg);
int Nscgfxfn_setvipbase(PGAL_BASE arg);
int Nscgfxfn_setvipbusrth(PGAL_BASE arg);
int Nscgfxfn_getvipbusrth(PGAL_BASE arg);
int Nscgfxfn_setviplastline(PGAL_BASE arg);
int Nscgfxfn_getvipbase(PGAL_BASE arg);
int Nscgfxfn_getvipline(PGAL_BASE arg);
int Nscgfxfn_testvipoddfield(PGAL_BASE arg);
int Nscgfxfn_testvipbasesupdated(PGAL_BASE arg);
int Nscgfxfn_testvipfifooverflow(PGAL_BASE arg);
int Nscgfxfn_setvbienable(PGAL_BASE arg);
int Nscgfxfn_getvbienable(PGAL_BASE arg);
int Nscgfxfn_setvbibase(PGAL_BASE arg);
int Nscgfxfn_getvbibase(PGAL_BASE arg);
int Nscgfxfn_setvbipitch(PGAL_BASE arg);
int Nscgfxfn_getvbipitch(PGAL_BASE arg);
int Nscgfxfn_setvbimode(PGAL_BASE arg);
int Nscgfxfn_getvbimode(PGAL_BASE arg);
int Nscgfxfn_getvbidirect(PGAL_BASE arg);
int Nscgfxfn_setvbidirect(PGAL_BASE arg);
int Nscgfxfn_setvbiinterrupt(PGAL_BASE arg);
int Nscgfxfn_getvbiinterrupt(PGAL_BASE arg);
int Nscgfxfn_seticonenable(PGAL_BASE arg);
int Nscgfxfn_seticoncolors(PGAL_BASE arg);
int Nscgfxfn_seticonposition(PGAL_BASE arg);
int Nscgfxfn_seticonshape64(PGAL_BASE arg);
int Nscgfxfn_gfx2setsourcestride(PGAL_BASE arg);
int Nscgfxfn_gfx2setsourcetransparency(PGAL_BASE arg);
int Nscgfxfn_gfx2setalphamode(PGAL_BASE arg);
int Nscgfxfn_gfx2setalphavalue(PGAL_BASE arg);
int Nscgfxfn_gfx2patternfill(PGAL_BASE arg);
int Nscgfxfn_gfx2colorpatternfill(PGAL_BASE arg);
int Nscgfxfn_gfx2screentoscreenblt(PGAL_BASE arg);
int Nscgfxfn_gfx2monoexpandblt(PGAL_BASE arg);
int Nscgfxfn_gfx2colorbmptoscrblt(PGAL_BASE arg);
int Nscgfxfn_gfx2monobmptoscrblt(PGAL_BASE arg);
int Nscgfxfn_gfx2textblt(PGAL_BASE arg);
int Nscgfxfn_gfx2bresenhamline(PGAL_BASE arg);
int Nscgfxfn_gfx2synctovblank(PGAL_BASE arg);
int Nscgfxfn_getvideoyuvoffsets(PGAL_BASE arg);
int Nscgfxfn_setvideoleftcrop(PGAL_BASE arg);
int Nscgfxfn_setvideoverticaldownscale(PGAL_BASE arg);
int Nscgfxfn_setvbisource(PGAL_BASE arg);
int Nscgfxfn_getvbisource(PGAL_BASE arg);
int Nscgfxfn_setvbilines(PGAL_BASE arg);
int Nscgfxfn_getvbilines(PGAL_BASE arg);
int Nscgfxfn_setvbitotal(PGAL_BASE arg);
int Nscgfxfn_getvbitotal(PGAL_BASE arg);
int Nscgfxfn_setverticalscaleroffset(PGAL_BASE arg);
int Nscgfxfn_getverticalscaleroffset(PGAL_BASE arg);
int Nscgfxfn_getgenlockenable(PGAL_BASE arg);
int Nscgfxfn_setgenlockenable(PGAL_BASE arg);
int Nscgfxfn_getgenlockdelay(PGAL_BASE arg);
int Nscgfxfn_setgenlockdelay(PGAL_BASE arg);
int Nscgfxfn_settoplineinodd(PGAL_BASE arg);
int Nscgfxfn_readcrc(PGAL_BASE arg);
int Nscgfxfn_readwindowcrc(PGAL_BASE arg);
int Nscgfxfn_getmacrovisionenable(PGAL_BASE arg);
int Nscgfxfn_setmacrovisionenable(PGAL_BASE arg);
int Nscgfxfn_getalphasize(PGAL_BASE arg);
int Nscgfxfn_getalphavalue(PGAL_BASE arg);
int Nscgfxfn_getalphapriority(PGAL_BASE arg);
int Nscgfxfn_getalphacolor(PGAL_BASE arg);
#endif
