 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) 2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * File Contents: This file contains the Geode frame buffer  the 
  *                Geode frame buffer information structure and video
  *                mode parameters structures.
  *
  * Project:       Geode Frame buffer device driver
  * </DOC_AMD_STD>
  * 
  */


#ifndef GEODEFB_H
#define GEODEFB_H

#define DEBUGMSG(_Cond, _Printf_Exp)\
        ((_Cond)?(printk _Printf_Exp),1:0)

/*
 *  This structure describes the board.
 */
struct geodefb_info
{

   /* Use the generic framebuffer ops */
   struct fb_info_gen gen;

   /* Device dependent information */
   int geode_type;

   /* geode type: {8plane, 24plane, 24plusZ} */
   unsigned int geode_mem_base;
   unsigned long geode_fb_base;
   unsigned long geode_regs_base;

   /* default video mode */
   struct fb_var_screeninfo default_var;
};

/*
 *  This structure uniquely defines a video mode.
 */

struct geodefb_par
{

   int xres, yres;                      /* resolution in pixels */
   unsigned int htimings;               /* horizontal timing register */
   unsigned int vtimings;               /* vertical timing register */
   unsigned int pll_freq;               /* pixclock in mhz */
   unsigned int bits_per_pixel;         /* bits per pixel */
};

#endif /* GEODEFB_H */
