 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) 2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * File Contents: This file contains the main functions of the Geode 
  *                frame buffer device driver, which includes functions 
  *                init, setup and ioctl etc.
  * [Notes:]           All the geode frame buffer driver functions can be 
  *                invoked through fbmem.c file functions
  *
  * Project:       Geode Frame buffer device driver
  * </DOC_AMD_STD>
  * 
  */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/version.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/tty.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,17)
#include <linux/slab.h>
#else
#include <linux/malloc.h>
#endif
#include <linux/delay.h>
#include <linux/fb.h>
#include <linux/console.h>
#include <linux/selection.h>
#include <linux/ioport.h>
#include <linux/init.h>
#include <linux/devfs_fs_kernel.h>

#include <asm/io.h>
#include <asm/mtrr.h>

#include <video/fbcon.h>
#include <video/fbcon-cfb8.h>
#include <video/fbcon-cfb16.h>
#include <video/fbcon-cfb32.h>

#include <asm/uaccess.h>

#include "gfx_rtns.h"
#include "gfx_defs.h"
#include "gfx_regs.h"

#ifdef CONFIG_FB_NSC_FP
#include "panel.h"
#endif
#ifdef CONFIG_FB_NSC_DDC
#include "ddc.h"
#endif

/* Enable/Disable acceleration by toggling the value 0/1 */
#define ACCEL 1

#define arraysize(x) (sizeof(x)/sizeof(*(x)))
#define FB_ACCEL_NSC_GEODE   40

/* Gx2 comes with CRT or TFT support */
#define RC_CRT  0x1
#define RC_TFT  0x2

/* Geode Frame buffer driver version */
#define NSCFB_MAJOR 2
#define NSCFB_MINOR 7
#define NSCFB_SUB 14

#define PUT_TVO      0x4701             /* TVO IOCTL entry code */
#define FB_DEBUG     0x4702             /* i/f to turn on selective debugging at runtime */

#define GEODEFBDEBUG 0                 /* enable debug output? */

#if GEODEFBDEBUG
#define DPort 0x84
#define DebugPort(_val) gfx_outb(DPort, (_val))

#define DPRINTK(fmt, args...) printk(KERN_INFO "%s: " fmt, __FUNCTION__ , ## args)
#else
#define DPRINTK(fmt, args...)
#define DebugPort(_val)
#endif

/* disable runtime assertions? */

#define GEODE_NDEBUG 1

/* debugging assertions */
#if GEODE_NDEBUG
#define assert(expr)\
        if(!(expr)) {\
                printk( "Assertion failed! %s,%s,%s,line=%d\n",\
                #expr,__FILE__,__FUNCTION__,__LINE__);\
        }
#else
#define assert(expr)
#endif

/* display types */

#define Display_CRT              0x01
#define Display_FP               0x02
#define Display_TV_NTSC          0x04
#define Display_TV_PAL           0x08
#define Display_TV               0x10
#define Display_TV_Square_Pixels 0x20
#define Display_TV_No_Scaling    0x40
#define Display_TVO              0x80
#define Display_TVMASK           0xFC

#define PIXCLOCK_ERR 0.6

typedef struct _Pnl_POV
{
   int Width;
   int Height;
   int Bpp;
   int Color;
   int Type;
}
Pnl_POV;

/*  dynamic offsets parameters */
struct TVO_scan
{
   int TV_Overscan_On;
   int TVOx;
   int TVOy;
   int TVOw;
   int TVOh;
};

struct geodefb_par
{
   int xres;
   int yres;
   int xres_virtual;
   int yres_virtual;
   int bpp;
   int refresh;
   int pixclock;
   int accel;
   unsigned int TVOx;                   /* x offset */
   unsigned int TVOw;                   /* width */
   unsigned int TVOy;                   /* y offset */
   unsigned int TVOh;                   /* height */
   unsigned int flags;                  /* flag */
};

union fb_gx_cmap
{
#ifdef FBCON_HAS_CFB16
   u16 cfb16[16];
#endif
#ifdef FBCON_HAS_CFB32
   u32 cfb32[16];
#endif
};

struct fb_gx_palette
{
   unsigned short red;
   unsigned short green;
   unsigned short blue;
};

#ifndef EXTERN_DEFINED
#define EXTERN extern
#define ASSIGN(var, val) var 
#else
#define EXTERN
#define ASSIGN(var, val) var = val
#endif

EXTERN union fb_gx_cmap fbcon_cmap;
EXTERN struct fb_gx_palette Geode_palette[256];
EXTERN struct geodefb_par current_par;
EXTERN char ASSIGN(default_fontname[40], { 0 });
EXTERN int ASSIGN(current_par_valid, 0);
EXTERN int ASSIGN(currcon, 0);
EXTERN struct display disp;
EXTERN struct fb_info_gen gen;
EXTERN unsigned int ASSIGN(compression, 1);
EXTERN int ASSIGN(rc, 0);
EXTERN unsigned int GeodeMem_phys;
EXTERN unsigned int GeodeRegs_phys;
EXTERN unsigned int GeodeRegs_phys_size;
EXTERN unsigned int GeodeMem_virt;
EXTERN unsigned int GXFBMemSize;
EXTERN int ASSIGN(blit_maybe_busy, 0);
EXTERN int ASSIGN(Sxres, 0) ;
EXTERN int ASSIGN(Syres, 0); 
EXTERN int ASSIGN(Sbpp, 0); 
EXTERN int ASSIGN(Shz, 0); 
EXTERN int ASSIGN(SDisplayType, 0);
EXTERN int ASSIGN(putcs_dbg, 0);
EXTERN char ASSIGN(geodefb_name[16], "Geode FB"); /*  Frame Buffer Name   */
EXTERN int ASSIGN(Display_Type, Display_CRT);
EXTERN unsigned int ASSIGN(vesa, ~0);  /* "nscfb:vesa:xxxxx" */
EXTERN unsigned int ASSIGN(vfreq, 60); /* "nscfb:vfreq:xxxxx" */
EXTERN int ASSIGN(Geodefb_inverse, 0);
EXTERN unsigned int ASSIGN(detect_hw_platform, 0);
EXTERN unsigned int cpu_version;
EXTERN char ASSIGN(*delimits, ",:");
EXTERN struct fb_var_screeninfo geodefb_default;
EXTERN int ASSIGN(geodefb_default_valid, 0);

#ifdef CONFIG_FB_NSC_DDC
EXTERN unsigned int ASSIGN(ddc_depth, 8); /* default ddc depth */
EXTERN int ASSIGN(ddc, 0);
#endif

#ifdef CONFIG_FB_NSC_FP
EXTERN int FPBP, FPBX, FPBY, FPBD, FPBF;
EXTERN int ASSIGN(flatpanel, 0);
#endif

#ifdef CONFIG_FB_NSC_TV
EXTERN int ASSIGN(is_tv_set, -1);
EXTERN int ASSIGN(tv_output, 2);  /* default to S_VIDEO */
EXTERN struct TVO_scan defaultTVO;
#endif

EXTERN char ASSIGN(*vmode, NULL);  /* "vmode=xxxxx" */
EXTERN char kvmode[20];
#ifdef MODULE
EXTERN char ASSIGN(*font, NULL);   /* "font=xxxxx" */
#ifdef CONFIG_FB_NSC_TV
EXTERN char ASSIGN(*TVO, NULL);  /* "TVO=xx:xx:xx:xx" */
#endif
#endif

EXTERN int geodefb_pan_display(struct fb_var_screeninfo *var, int con,
                               struct fb_info *info);
/* Hardware Specific Routines */
EXTERN void Geode_WaitBusy(void);
EXTERN int NSC_PROC_CONSOLE(const struct fb_info *info);
EXTERN unsigned long frequency2fixedformat(double frequency);
EXTERN double fixedformat2frequency(unsigned long frequency);
EXTERN unsigned int does_pixclock_match(const struct fb_var_screeninfo *var,
                                        struct geodefb_par *par, int *hz,
                                        int *pixclock);
EXTERN void set_crt_pixclock(struct fb_var_screeninfo *var);
EXTERN unsigned int calc_err(unsigned long pixclock);
EXTERN int geodefb_ioctl_ext(struct inode *inode,
                             struct file *file,
                             u_int cmd,
                             u_long arg, int con, struct fb_info *info);
