 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) 2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * File Contents: This file contains the macro definitions and data structure  
  *                definitions of DDC.  
  * 			
  * SubModule:     Display Data Channel support.
  * </DOC_AMD_STD>
  * 
  */

#ifndef _ddc_defs_h
#define _ddc_defs_h

typedef struct _Predefined_DDC{
	unsigned long xres;
	unsigned long yres;
	unsigned long hz;
}Predefined_DDC;

#define	DEFAULTDELAY	1	/* 1 mSec */

/* Data locations in VESA/EDID ver1.3 format containg 128 Bytes */
#define VESA1_VERSION 12
#define VESA1_REVSION 13
#define VESA1_EST_TIM1 35
#define VESA1_EST_TIM2 36
#define VESA1_EST_MANU_TIM 37
#define VESA1_EST_STAND_TIM 38

/* defines the predefined modes */

Predefined_DDC EstTim1[8] ={
	{800, 600, 60},
	{800, 600, 56},
	{640, 480, 75},
	{640, 480, 72},
	{640, 480, 67},
	{640, 480, 60}, 
	{720, 400, 88}, 
	{720, 400, 70}
};  
Predefined_DDC EstTim2[8] ={
	{1280, 1024, 75},
	{1024, 768, 75}, 
	{1024, 768, 70}, 
	{1024, 768, 60}, 
	{1024, 768, 87}, 
	{832, 624, 75},  
	{800, 600, 75},
	{800, 600, 72}
};
Predefined_DDC MfgTim2[1] ={
	{1152, 870, 75} 
};

typedef struct _DispAspectRatio{
	int xRatio;
	int yRatio;
}DispAspectRatio;

static DispAspectRatio asp[4] = {
	{1, 1},
	{4, 3},
	{5, 4},
	{16, 9}
};
static unsigned char EDID_Header[8] = {
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00};

typedef struct _Platform_DDC_ops {
	void (*init)(void);
	unsigned char (*ReadByte)(int);
	void (*StartBit)(void);
	void (*StopBit)(void);
	void (*Ack)(int);
	int (*waitForAck)(void);
	void (*requestData)(void);
	void (*startXfer)(void);
	void (*endXfer)(void);
	void (*SetSCL)(void);
	void (*ClearSCL)(void);
	void (*ClearSDA)(void);
	void (*SetSDA)(void);
	int (*GetSDA)(void);
	int (*GetSCL)(void);
} Platform_DDC_ops;

#endif /* !_ddc_defs_h */

/* END OF FILE */
