% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{is_abs_path}
\alias{is_abs_path}
\alias{is_rel_path}
\title{Test if paths are relative or absolute}
\usage{
is_abs_path(x)

is_rel_path(x)
}
\arguments{
\item{x}{A vector of paths.}
}
\value{
A logical vector.
}
\description{
On Unix, check if the paths start with \file{/} or \file{~} (if they do, they
are absolute paths). On Windows, check if a path remains the same (via
\code{\link[=same_path]{same_path()}}) if it is prepended with \file{./} (if it does, it is a
relative path).
}
\examples{
xfun::is_abs_path(c("C:/foo", "foo.txt", "/Users/john/", tempdir()))
xfun::is_rel_path(c("C:/foo", "foo.txt", "/Users/john/", tempdir()))
}
