% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_analysis.R
\name{wbt_create_colour_composite}
\alias{wbt_create_colour_composite}
\title{Create colour composite}
\usage{
wbt_create_colour_composite(
  red,
  green,
  blue,
  output,
  opacity = NULL,
  enhance = TRUE,
  zeros = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{red}{Input red band image file.}

\item{green}{Input green band image file.}

\item{blue}{Input blue band image file.}

\item{output}{Output colour composite file.}

\item{opacity}{Input opacity band image file (optional).}

\item{enhance}{Optional flag indicating whether a balance contrast enhancement is performed.}

\item{zeros}{Optional flag to indicate if zeros are nodata values.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Creates a colour-composite image from three bands of multispectral imagery.
}
\keyword{ImageProcessingTools}
