% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_mab_methods.R
\name{print.multiple.mab}
\alias{print.multiple.mab}
\title{Print Generic For \code{multiple.mab}}
\usage{
\method{print}{multiple.mab}(x, ...)
}
\arguments{
\item{x}{A \code{multiple.mab} class object created by \code{\link[=multiple_mab_simulation]{multiple_mab_simulation()}}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Text summary of settings used for the Multi-Arm Bandit trials.
}
\description{
Custom Print Display for \code{multiple.mab} objects returned by \code{\link[=multiple_mab_simulation]{multiple_mab_simulation()}}.
Prevents the large list output from being printed directly, and provides
useful information about the settings for the trials.
}
\details{
The items used to create the text summary can be found in the settings
element of the output object.

\code{...} is provided to be compatible with \code{print()}, no other arguments
change output.
}
\examples{
# Running Multiple Simulations
x <- multiple_mab_simulation(
  data = tanf,
  algorithm = "thompson",
  assignment_method = "Batch",
  period_length = 1750,
  prior_periods = "All",
  blocking = FALSE,
  whole_experiment = TRUE,
  perfect_assignment = TRUE,
  data_cols = c(
    id_col = "ic_case_id",
    success_col = "success",
    condition_col = "condition"
  ),
  times = 5, seeds = sample.int(5)
)
print(x)
}
