% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mab_assign.R
\name{get_past_results}
\alias{get_past_results}
\title{Gather Past Results for Given Assignment Period}
\usage{
get_past_results(
  current_data,
  prior_data,
  perfect_assignment,
  assignment_date_col = NULL,
  conditions
)
}
\arguments{
\item{current_data}{A tibble/data.table with only observations from the current sampling period.}

\item{prior_data}{A tibble/data.table with only the observations from the prior index.}

\item{perfect_assignment}{Logical; if TRUE, assumes perfect information for treatment assignment
(i.e., all outcomes are observed regardless of the date).
If FALSE, hides outcomes not yet theoretically observed, based
on the dates treatments would have been assigned for each wave.
This is useful when simulating batch-based assignment where treatments were assigned
on a given day whether or not all the information from a prior batch was available and
you have exact dates treatments were assigned.}

\item{assignment_date_col}{Column in \code{data}; contains original dates treatments were assigned to observations. Only necessary when \code{perfect_assignment = FALSE}.
Used to simulate imperfect information on the part of researchers conducting an adaptive trial. Must be of type \code{Date}, not a character string.}
}
\value{
A tibble/data.table containing the number of successes, and number of people for each
treatment condition.
}
\description{
Summarizes results of prior periods to use for the current Multi-Arm-Bandit assignment. This function
calculates the number of success under each treatment and the total number of observations assigned to each treatment which are used
to calculate UCB1 values or Thompson sampling probabilities.
}
\details{
When \code{perfect_assignment} is FALSE, the maximum value from the specified
\code{assignment_date_col} in the current data is taken as the last possible date
the researchers conducting the experiment could have learned about a treatment outcome.
All successes that occur past this date are masked and treated as failures for the purposes
of assigning this treatments periods, as it simulates the researchers not having
received that information yet.
}
\seealso{
\itemize{
\item \code{\link[=run_mab_trial]{run_mab_trial()}}
\item \code{\link[=single_mab_simulation]{single_mab_simulation()}}
\item \code{\link[=get_bandit]{get_bandit()}}
}
}
\keyword{internal}
