% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webhook.R
\name{whapi_trunc}
\alias{whapi_trunc}
\title{Truncate long strings for logging}
\usage{
whapi_trunc(x, max = 2000L)
}
\arguments{
\item{x}{A character string (or coercible to character).}

\item{max}{Integer. Maximum number of characters to display (default: 2000).}
}
\value{
A character string, possibly truncated.
}
\description{
Helper function to shorten long strings when printing to logs.
If the input string exceeds \code{max} characters, it is truncated and
suffixed with \code{"... (truncated)"}.
}
\examples{
whapi_trunc("short text", max = 10)
whapi_trunc(paste(rep("a", 5000), collapse = ""), max = 20)
}
