% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_check_health}
\alias{whapi_check_health}
\title{Check Whapi.Cloud channel health and status}
\usage{
whapi_check_health(
  wakeup = TRUE,
  channel_type = c("web", "mobile"),
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{wakeup}{Logical(1). If TRUE, adds \code{wakeup=true} query param. Default: TRUE.}

\item{channel_type}{Character(1). Channel type, either \code{"web"} or \code{"mobile"}. Default: \code{"web"}.}

\item{token}{Character(1). Bearer token. Defaults to env var \code{WHAPI_TOKEN}.}

\item{timeout}{Numeric(1). Request timeout (s). Default 30.}

\item{verbose}{Logical(1). Print CLI logs? Default TRUE.}
}
\value{
A tibble with key health information:
\itemize{
\item \code{channel_id}, \code{uptime}, \code{version}, \code{core_version}, \code{api_version},
\item \code{device_id}, \code{ip},
\item \code{status_code}, \code{status_text},
\item \code{user_id}, \code{user_name}, \code{user_pushname}, \code{is_business},
\item \code{profile_pic}, \code{profile_pic_full}, \code{user_status},
plus the raw response in \code{resp}.
}
}
\description{
Calls \code{GET /health} to retrieve channel status, versions,
uptime, device, IP, and user info.
}
\examples{
\dontrun{
Sys.setenv(WHAPI_TOKEN = "your_token_here")
# Default check (wakeup=TRUE, channel_type="web")
whapi_check_health()

# Check with channel_type = "mobile"
whapi_check_health(channel_type = "mobile")
}
}
