% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_separator}
\alias{umx_set_separator}
\title{Set the separator}
\usage{
umx_set_separator(umx_default_separator = NULL, silent = FALSE)
}
\arguments{
\item{umx_default_separator}{separator for CIs etc. (if empty, returns the current value)}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
- Current umx_default_separator
}
\description{
Set umx_default_separator (used in CI\[low sep high\] ). Default = ","
}
\examples{
library(umx)
umx_set_separator() # show current state
old = umx_set_separator(silent=TRUE) # store existing value
umx_set_separator("|")
umxAPA(.3, .2)
umx_set_separator(old)    # reinstate
}
\seealso{
Other Get and set: 
\code{\link{umx}},
\code{\link{umx_get_alphas}()},
\code{\link{umx_get_checkpoint}()},
\code{\link{umx_get_options}()},
\code{\link{umx_set_auto_plot}()},
\code{\link{umx_set_auto_run}()},
\code{\link{umx_set_checkpoint}()},
\code{\link{umx_set_condensed_slots}()},
\code{\link{umx_set_cores}()},
\code{\link{umx_set_data_variance_check}()},
\code{\link{umx_set_dollar_symbol}()},
\code{\link{umx_set_optimization_options}()},
\code{\link{umx_set_optimizer}()},
\code{\link{umx_set_plot_file_suffix}()},
\code{\link{umx_set_plot_format}()},
\code{\link{umx_set_silent}()},
\code{\link{umx_set_table_format}()}
}
\concept{Get and set}
