% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainsetBias.R
\name{trainsetBiasTree}
\alias{trainsetBiasTree}
\alias{trainsetBias}
\title{Trainset Bias}
\usage{
trainsetBiasTree(tidy.RF, tree)

trainsetBias(tidy.RF)
}
\arguments{
\item{tidy.RF}{A tidy random forest. The random forest to extract train
set bias from.}

\item{tree}{An integer. The index of the tree to look at.}
}
\value{
A matrix. The content depends the type of the response.
  \itemize{
    \item Regression: A 1-by-1 matrix. The trainset bias for the prediction
      of the response.
    \item Classification: A 1-by-D matrix, where D is the number of response
      classes. Each column of the matrix stands for the trainset bias for
      the prediction of each response class.
  }
}
\description{
For a tree in the forest, trainset bias is the prediction of its root node,
or the unconditional prediction of the tree, or the average response of the
samples used to train the tree.
}
\details{
For a forest, the trainset bias is simply the average trainset bias across
all trees. This is because the prediction of a forest is the average of the
predictions of its trees.

Together with \code{featureContrib(Tree)}, they can decompose the prediction
by feature importance:

\deqn{prediction(MODEL, X) =
    trainsetBias(MODEL) +
    featureContrib_1(MODEL, X) + ... + featureContrib_p(MODEL, X),}

where MODEL can be either a tree or a forest.
}
\section{Functions}{
\itemize{
\item \code{trainsetBiasTree}: Trainset bias within a single tree

\item \code{trainsetBias}: Trainset bias within the whole forest
}}

\examples{
library(ranger)
rfobj <- ranger(Species ~ ., iris, keep.inbag=TRUE)
tidy.RF <- tidyRF(rfobj, iris[, -5], iris[, 5])
trainsetBiasTree(tidy.RF, 1)
trainsetBias(tidy.RF)

}
\references{
Interpreting random forests
  \url{http://blog.datadive.net/interpreting-random-forests/}

Random forest interpretation with scikit-learn
  \url{http://blog.datadive.net/random-forest-interpretation-with-scikit-learn/}
}
\seealso{
\code{\link{featureContrib}}
}
