% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{toscca.perm}
\alias{toscca.perm}
\title{Permutation testing for toscca}
\usage{
toscca.perm(
  A,
  B,
  nonzero_a,
  nonzero_b,
  K,
  alpha_init = c("eigen", "random", "uniform"),
  folds = 1,
  toPlot = FALSE,
  draws = 20,
  cancor,
  silent = TRUE,
  parallel_logic = TRUE,
  nuisanceVar = 0,
  testStatType = "CC",
  ncores = NULL
)
}
\arguments{
\item{A, B}{Data matrices.}

\item{nonzero_a, nonzero_b}{Numeric. Scalar or vector over the number of nonzeroes allowed for a correlation estimate.}

\item{K}{Numeric. Number of components to be computed.}

\item{alpha_init}{Character. Type initialisation for \deqn{\mathbf{\alpha}}. Default is "eigen".}

\item{folds}{Numeric. Number of folds for the cross-validation process.}

\item{toPlot}{Logical. If TRUE, plot will be generated automatically showing the estimated canonical weights. Default is TRUE.}

\item{draws}{Numeric. Number of permutations for each component.}

\item{cancor}{Numeric. Scalar or vector: anonical correlation estimate(s).}

\item{silent}{Logical. If FALSE, a progress bar will appear on the console. Default is FALSE.}

\item{parallel_logic}{Logical. If TRUE, cross-validation is done in parallel.Default is FALSE.}

\item{nuisanceVar}{Data with nuisance variables. For statistic type.}

\item{testStatType}{Character. Choice of statistic. Options are CC (default), Wilks and Roy.}

\item{ncores}{numeric. Number of cores to use in parallelisation. Default is detectCores() -1.}
}
\value{
Matrix with permutation estimates.

List with permuted correlations and p-values.
}
\description{
This function performs permutation testing on CC estimates.
}
\details{
For a exploratory analysis nonzero_a and nonzero_b can be vectors. The algorithm will then search for the best combination of sparsity choice nonzero_a and nonzero_b for each component.
}
\examples{
#sample size etc
N = 10
p = 25
q = 5
# noise
X0 = sapply(1:p, function(x) rnorm(N))
Y0 = sapply(1:q, function(x) rnorm(N))

colnames(X0) = paste0("x", 1:p)
colnames(Y0) = paste0("y", 1:q)

# signal
Z1 = rnorm(N,0,1)


#Some associations with the true signal
alpha = (6:10) / 10
beta  = -(2:3) / 10

loc_alpha = 1:length(alpha)
loc_beta  = 1:length(beta)

for(j in 1:length(alpha))
  X0[, loc_alpha[j]] =  alpha[j] * Z1 + rnorm(N,0,0.3)

for(j in 1:length(beta))
  Y0[, loc_beta[j]] =  beta[j] * Z1 + rnorm(N,0,0.3)

X = standardVar(X0)
Y = standardVar(Y0)
K = 2                                       # number of components to be estimated
nonz_x = c(2,5, 10, 20)                     # number of nonzero variables for X
nonz_y = c(1, 2, 3, 4)                      # number of nonzero variables for Y
init   = "uniform"                          # type of initialisation
cca_toscca  = toscca(X, Y, nonz_x, nonz_y, K, alpha_init = init, silent = TRUE, toPlot = FALSE)
\donttest{
#dont run due to parallelisation.
cc = cca_toscca$cancor
perm_toscca = toscca.perm(X, Y, nonz_x, nonz_y, K = K, init, draws = 10, cancor = cc, ncores = 2)
}
}
