% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_fmod}
\alias{torch_fmod}
\title{Fmod}
\usage{
torch_fmod(self, other)
}
\arguments{
\item{self}{(Tensor) the dividend}

\item{other}{(Tensor or float) the divisor, which may be either a number or a tensor of the same shape as the dividend}
}
\description{
Fmod
}
\section{fmod(input, other, out=NULL) -> Tensor }{


Computes the element-wise remainder of division.

The dividend and divisor may contain both for integer and floating point
numbers. The remainder has the same sign as the dividend \code{input}.

When \code{other} is a tensor, the shapes of \code{input} and
\code{other} must be broadcastable .
}

\examples{
if (torch_is_installed()) {

torch_fmod(torch_tensor(c(-3., -2, -1, 1, 2, 3)), 2)
torch_fmod(torch_tensor(c(1., 2, 3, 4, 5)), 1.5)
}
}
