% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_function.R
\name{type_function}
\alias{type_function}
\title{Plot a function}
\usage{
type_function(fun = dnorm, args = list(), n = 101, ...)
}
\arguments{
\item{fun}{Function of \code{x} to plot. Defaults to \code{\link[stats]{dnorm}}.}

\item{args}{List of additional arguments to be passed to \code{fun}.}

\item{n}{Number of points to interpolate on the x axis.}

\item{...}{Additional arguments are passed to the \code{lines()} function,
ex: \code{type="p"}, \code{col="pink"}.}
}
\description{
Plot a function
}
\details{
When using \code{type_function()} in a \code{tinyplot()} call, the \code{x} value indicates
the range of values to plot on the x-axis.
}
\examples{
# Plot the normal density (default function)
tinyplot(x = -4:4, type = "function")
# tinyplot(x = -4:4, type = type_function()) # same

# Customize by passing explicit arguments to your function
tinyplot(x = -1:10, type = type_function(
  fun = dnorm, args = list(mean = 3)
))

# Additional arguments are passed to the `lines()` function.
tinyplot(x = -4:4, type = type_function(
  fun = dnorm,
  col = "pink", type = "p", pch = 3
))

# Custom function example
## (Here using `function(x)`, but you could also use the shorter `\(x)`
## anonymous function syntax introduced in R 4.1.0)
tinyplot(x = -4:4, type = type_function(fun = function(x) 0.5 * exp(-abs(x))))

}
