% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa0_tinycodet_help.R
\name{aaa0_tinycodet_help}
\alias{aaa0_tinycodet_help}
\alias{tinycodet-package}
\alias{tinycodet}
\alias{tinycodet_help}
\title{tinycodet: Functions to Help in your Coding Etiquette}
\description{
'tinycodet' adds some functions to help in your coding etiquette. \cr
It primarily focuses on 4 aspects: \cr
\cr
(1) Safer decimal (in)equality testing,
standard-evaluated alternatives to \code{with()} and \code{aes()},
and other functions for safer coding; \cr
see \link{tinycodet_safer}. \cr
\cr
(2) A new package import system,
that attempts to combine the benefits of using a package without attaching it,
with the benefits of attaching a package; \cr
see \link{tinycodet_import} \cr
\cr
(3) Extending the string manipulation capabilities of the 'stringi' R-package; \cr
see \link{tinycodet_strings}. \cr
\cr
(4) Reducing repetitive code; \cr
see \link{tinycodet_dry}. \cr
\cr
And some miscellaneous functionality; see \link{tinycodet_misc}. \cr
\cr
\cr
Please check the Change-log
(see links below)
regularly for updates (such as bug fixes). \cr
\cr
'tinycodet' adheres to the
\href{https://www.tinyverse.org/}{tinyverse}
philosophy.
Besides linking to 'Rcpp', 'tinycodet' only has one other dependency:
'stingi'.
No other dependencies, thus avoiding "dependency hell".
Most functions in this R-package are vectorized and optimised. \cr
\cr
}
\references{
The badges shown in the documentation of this R-package were made using the services of: \url{https://shields.io/}
}
\seealso{
Useful links:
\itemize{
\item 'tinycodet' GitHub main page and Read-Me: \url{https://github.com/tony-aw/tinycodet/}
\item 'tinycodet' package website: \url{https://tony-aw.github.io/tinycodet/}
\item Report bugs at: \url{https://github.com/tony-aw/tinycodet/issues/}
\item Changelog: \url{https://github.com/tony-aw/tinycodet/blob/main/NEWS.md/} or \cr \url{https://tony-aw.github.io/tinycodet/news/index.html}
\item The 'fastverse', which is related to the 'tinyverse': \url{https://github.com/fastverse/fastverse/}
}
}
\author{
\strong{Maintainer}: Tony Wilkes \email{tony_a_wilkes@outlook.com} (\href{https://orcid.org/0000-0001-9498-8379}{ORCID})
}
