% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_text.R
\name{generate_analysis}
\alias{generate_analysis}
\title{Generate analytical paragraphs (rule-based)}
\usage{
generate_analysis(
  df,
  classe_conama = "2",
  incluir_tendencia = TRUE,
  parametros_tendencia = c("turbidez", "od", "pH"),
  contexto = list(rio = NA, periodo = NA, cidade = NA)
)
}
\arguments{
\item{df}{Data frame contendo ao menos a coluna \code{ponto}. Recomenda-se
tambem as colunas necessarias para checagens CONAMA e para o calculo do IQA.}

\item{classe_conama}{Character (ex. "2"). Classe-alvo para a checagem da
Resolucao CONAMA 357/2005.}

\item{incluir_tendencia}{Logical; se \code{TRUE}, calcula tendencias lineares
simples ao longo do tempo.}

\item{parametros_tendencia}{Character vector; nomes dos parametros para testar
tendencia temporal.}

\item{contexto}{Lista com metadados opcionais (PT/EN), por exemplo
\code{list(rio = "Rio Pardo", periodo = "jan–jun/2025", cidade = "Lencois")}.
As chaves aceitas sao \code{rio}/\code{river}, \code{periodo}/\code{period}, \code{cidade}.}
}
\value{
Vetor \code{character} com 3 a 5 paragrafos analiticos prontos para relatorio.
}
\description{
Produz 3–5 paragrafos curtos, legiveis por humanos, resumindo a qualidade da
agua a partir de IQA/WQI, conformidade com a CONAMA 357/2005 e (opcionalmente)
tendencias temporais simples. E \strong{rule-based} (nao usa IA) e aceita metadados
opcionais para compor o texto.
}
\examples{
\dontrun{
library(tikatuwq)
data("wq_demo")
txt <- generate_analysis(
  df = wq_demo,
  classe_conama = "2",
  incluir_tendencia = TRUE,
  parametros_tendencia = c("turbidez","od","pH"),
  contexto = list(rio = "Rio Azul", periodo = "jan–jun/2025")
)
cat(paste(txt, collapse = "\n\n"))
}

}
\seealso{
\code{\link[=iqa]{iqa()}}, \code{\link[=conama_check]{conama_check()}}
}
\concept{reporting-tools}
