% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_analysis_sentimentr.R
\name{sentiment_analysis_sentimentr}
\alias{sentiment_analysis_sentimentr}
\title{Sentiment Analysis using sentimentr}
\usage{
sentiment_analysis_sentimentr(
  documents,
  sentences,
  dictionary_file,
  use_dictionary_file_in_sentimentr
)
}
\arguments{
\item{documents}{A character vector of document identifiers for which sentiment analysis needs to be performed. This is included for consistency, but is not directly used in the analysis.}

\item{sentences}{A data frame containing sentence-level data. It should include the following columns:
\itemize{
\item \code{sentenceid}: The unique identifier of the sentence.
\item \code{sentence}: The sentence text that needs to be analyzed.
\item \code{document}: The identifier of the document to which the sentence belongs.
}}

\item{dictionary_file}{A string representing the path to a CSV file containing the sentiment dictionary. The file should have two columns:
\itemize{
\item \code{word}: The words in the lexicon.
\item \code{value}: The sentiment value associated with the word.
}}

\item{use_dictionary_file_in_sentimentr}{A boolean determining whether the dictionary file is used (TRUE) or the built-in lexicon (FALSE)}
}
\value{
A data table with the following columns:
\itemize{
\item \code{sentenceid}: The ID of the sentence.
\item \code{sentence}: The sentence being analyzed.
\item \code{polarity}: The sentiment polarity score for the sentence.
\item \code{document}: The document identifier to which the sentence belongs.
}
}
\description{
This function performs sentiment analysis on sentences using a predefined lexicon and the \code{sentimentr} package. The sentiment score is calculated based on a dictionary of words with associated sentiment values.
}
\details{
This function loads a sentiment dictionary, processes the sentences, and calculates a sentiment score for each sentence using the \code{sentimentr} package. The dictionary is expected to have words associated with sentiment values that influence the sentiment score calculation. Positive sentiment scores indicate a positive sentiment, while negative values indicate negative sentiment.

The dictionary file (\code{SumUp_Dictionary.csv}) is read from the \verb{data/} directory by default. The file should have a column of words and corresponding sentiment values.
}
