% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_tbl.R
\name{select_tbl}
\alias{select_tbl}
\title{Summarize multiple response variables}
\usage{
select_tbl(
  data,
  var_stem,
  var_input = "stem",
  regex_stem = FALSE,
  ignore_stem_case = FALSE,
  na_removal = "listwise",
  pivot = "longer",
  only = NULL,
  var_labels = NULL,
  ignore = NULL,
  force_pivot = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{var_stem}{A character vector with one or more elements, where each
represents either a variable stem or the complete name of a variable present
in \code{data}. A variable 'stem' refers to a common naming pattern shared among
related variables, typically reflecting repeated measures of the same idea
or a group of items assessing a single concept.}

\item{var_input}{A character string specifying whether the values
supplied to \code{var_stem} should be treated as variable stems (\code{stem}) or
as complete variable names (\code{name}). By default, this is set to \code{stem},
so the function searches for variables that begin with each stem provided.
Setting this argument to \code{name} directs the function to look for variables
that exactly match the provided names.}

\item{regex_stem}{A logical value indicating whether to use Perl-compatible
regular expressions when searching for variable stems. Default is \code{FALSE}.}

\item{ignore_stem_case}{A logical value indicating whether the search for
columns matching the supplied \code{var_stem} is case-insensitive. Default is
\code{FALSE}.}

\item{na_removal}{A character string that specifies the method for handling
missing values: \code{pairwise} or \code{listwise}. Defaults to \code{listwise}.}

\item{pivot}{A character string that determines the format of the table. By
default, \code{longer} returns the data in the long format. To receive the data in
the \code{wide} format, specify \code{wider}.}

\item{only}{A character string or vector of character strings of the types of
summary data to return. Default is \code{NULL}, which returns both counts and
percentages. To return only counts or percentages, use \code{count} or \code{percent},
respectively.}

\item{var_labels}{An optional named character vector or list used to assign
custom labels to variable names. Each element must be named and correspond
to a variable included in the returned table. If \code{var_input} is set to \code{stem},
and any element is either unnamed or refers to a variable not present in the
table, all labels will be ignored and the table will be printed without them.}

\item{ignore}{An optional named vector or list indicating values to exclude
from variables matching specified stems (or names). Defaults to \code{NULL},
indicating that all values are retained. To specify exclusions for variables
identified by \code{var_stem}, use the corresponding stems or variable names as
names in the vector or list. To exclude multiple values from these variables,
supply them as a named list.}

\item{force_pivot}{A logical value that enables pivoting to the 'wider'
format even when variables have inconsistent value sets. By default, this is
set to \code{FALSE} to prevent reshaping errors when values differ across variables
in the returned table. Set to \code{TRUE} to override this safeguard and pivot to
the 'wider' format regardless of value inconsistencies.}
}
\value{
A tibble displaying the count and percentage for each category in a
multi-response variable.
}
\description{
\code{select_tbl()} displays frequency counts and percentages
for multiple response variables (e.g., a series of questions where
participants answer "Yes" or "No" to each item) as well as ordinal
variables (such as Likert or Likert-type items with responses ranging
from "Strongly Disagree" to "Strongly Agree", where respondents select
one response per statement, question, or item).
}
\examples{
select_tbl(data = tas,
           var_stem = "involved_",
           na_removal = "pairwise")

select_tbl(data = depressive,
           var_stem = "dep",
           na_removal = "listwise",
           pivot = "wider",
           only = "percent")

var_label_example <-
  c("dep_1" = "how often child feels sad and blue",
    "dep_2" = "how often child feels nervous, tense, or on edge",
    "dep_3" = "how often child feels happy",
    "dep_4" = "how often child feels bored",
    "dep_5" = "how often child feels lonely",
    "dep_6" = "how often child feels tired or worn out",
    "dep_7" = "how often child feels excited about something",
    "dep_8" = "how often child feels too busy to get everything")

select_tbl(data = depressive,
           var_stem = "dep",
           na_removal = "pairwise",
           pivot = "longer",
           var_labels = var_label_example)

select_tbl(data = depressive,
           var_stem = "dep",
           na_removal = "pairwise",
           pivot = "wider",
           only = "count",
           var_labels = var_label_example)

}
\author{
Ama Nyame-Mensah
}
