% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{is_orthonormal}
\alias{is_orthonormal}
\title{Orthonormality of a matrix}
\usage{
is_orthonormal(x, tol = 0.001)
}
\arguments{
\item{x}{Numeric matrix to test the orthonormality of.}

\item{tol}{Max tolerance of floating point differences of the
element-wise distance of t(x) \%*\% x from the identity matrix.}
}
\value{
Single logical, whether or not the matrix is orthonormal.
}
\description{
Test if a numeric matrix is orthonormal, that is, each column is orthogonal,
at a right angle with the others, and each column has a norm
length of 1. This must be true for a projection to be linear.
}
\examples{
spinifex::is_orthonormal(tourr::basis_random(n = 6))
spinifex::is_orthonormal(matrix(1:12, ncol = 2), tol = 0.01)
}
