% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.rpm.R, R/anova.rpmlist.R
\name{anova.rpm}
\alias{anova.rpm}
\alias{anova_rpmlist}
\title{ANOVA for rpm Fits}
\usage{
\method{anova}{rpm}(object, ...)

anova_rpmlist(object, ...)
}
\arguments{
\item{object, ...}{objects of class \code{\link{rpm}}, usually, a result of a
call to \code{\link{rpm}}.}
}
\value{
An object of class \code{"anova"} inheriting from class
\code{"data.frame"}.
}
\description{
Compute an analysis of variance table for one or more rpm fits.
}
\details{
Specifying a single object gives a sequential analysis of variance table for
that fit.  That is, the reductions in the residual sum of squares as each
term of the formula is added in turn are given in the rows of a table, plus
the residual sum of squares.

The table will contain F statistics (and P values) comparing the mean square
for the row to the residual mean square.

If more than one object is specified, the table has a row for the residual
degrees of freedom and sum of squares for each model.  For all but the first
model, the change in degrees of freedom and sum of squares is also given.
(This only make statistical sense if the models are nested.)  It is
conventional to list the models from smallest to largest, but this is up to
the user.

Optionally the table can include test statistics.  Normally the F statistic
is most appropriate, which compares the mean square for a row to the
residual sum of squares for the largest model considered.  If \code{scale}
is specified chi-squared tests can be used. Mallows' \eqn{C_p}{Cp} statistic
is the residual sum of squares plus twice the estimate of
\eqn{\sigma^2}{sigma^2} times the residual degrees of freedom.

If any of the objects do not have estimated log-likelihoods, produces an
error, unless \code{eval.loglik=TRUE}.
}
\section{Warning}{
 The comparison between two or more models will only be
valid if they are fitted to the same dataset. This may be a problem if there
are missing values.
}

\examples{
library(rpm)
data(fauxmatching)
\donttest{
fit <- rpm(~match("edu") + WtoM_diff("edu",3),
          Xdata=fauxmatching$Xdata, Zdata=fauxmatching$Zdata,
          X_w="X_w", Z_w="Z_w",
          pair_w="pair_w", pair_id="pair_id", Xid="pid", Zid="pid",
          sampled="sampled",sampling_design="stock-flow")
anova(fit)
}
}
\seealso{
The model fitting function \code{\link{rpm}}, \code{\link{anova}},
\code{\link{logLik.rpm}} for adding the log-likelihood to an existing
\code{\link[=rpm.object]{rpm}} object.
}
\keyword{models}
\keyword{regression}
