% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_neighbors_helpers.R
\name{diss_to_neighbors}
\alias{diss_to_neighbors}
\title{From dissimilarity matrix to neighbors}
\usage{
diss_to_neighbors(
  diss_matrix,
  k = NULL,
  k_diss = NULL,
  k_range = NULL,
  spike = NULL,
  return_dissimilarity = FALSE,
  skip_first = FALSE
)
}
\arguments{
\item{diss_matrix}{a matrix representing the dissimilarities between
observations in a matrix \code{Xu} and observations in another matrix
\code{Xr}. \code{Xr} in rows \code{Xu} in columns.}

\item{k}{an integer value indicating the k-nearest neighbors of each
observation in \code{Xu} that must be selected from \code{Xr}.}

\item{k_diss}{an integer value indicating a dissimilarity treshold.
For each observation in \code{Xu}, its nearest neighbors in \code{Xr}
are selected as those for which their dissimilarity to \code{Xu} is below
this \code{k_diss} threshold. This treshold depends on the corresponding
dissimilarity metric specified in \code{diss_method}. Either \code{k} or
\code{k_diss} must be specified.}

\item{k_range}{an integer vector of length 2 which specifies the minimum
(first value) and the maximum (second value) number of neighbors to be
retained when the \code{k_diss} is given.}

\item{spike}{a vector of integers indicating what observations in \code{Xr}
(and \code{Yr}) must be 'forced' to always be part of all the neighborhoods.}

\item{return_dissimilarity}{logical indicating if the input dissimilarity
must be mirroed in the output.}

\item{skip_first}{a logical indicating whether to skip the first neighbor or
not. Default is \code{FALSE}. This is used when the search is being conducted
in symmetric matrix of distances (i.e. to avoid that the nearest neighbor of
each observation is itself).}
}
\description{
internal
}
\keyword{internal}
