% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-pack.R, R/op-cdo-pack.R
\name{pack}
\alias{pack}
\alias{cdo_pack}
\title{Pack data}
\usage{
cdo_pack(ifile, printparam = NULL, filename = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{printparam}{BOOL - Print pack parameters to stdout for each variable}

\item{filename}{STRING - Read pack parameters from file for each variable[format: name=<> add_offset=<> scale_factor=<>]}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
Packing reduces the data volume by reducing the precision of the stored numbers. It is implemented using the NetCDF attributes add_offset and scale_factor. The operator pack calculates the attributes add_offset and scale_factor for all variables. The default data type for all variables is automatically changed to 16-bit integer. Use the CDO option -b to change the data type to a different integer precision, if needed. Missing values are automatically transformed to the current data type.  Alternatively, the pack parameters add_offset and scale_factor can be read from a file for each variable.
}
