% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-detrend.R, R/op-cdo-detrend.R
\name{detrend}
\alias{detrend}
\alias{cdo_detrend}
\title{Detrend time series}
\usage{
cdo_detrend(ifile, equal = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{equal}{BOOL - Set to false for unequal distributed timesteps (default: true)}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
Every time series in infile is linearly detrended. For every field element x only those timesteps t belong to the sample S(x), which have i(t,x) NE miss. It is assumed that all timesteps are equidistant, if this is not the case set the parameter equal=false.
}
\section{Note}{

This operator has to keep the fields of all timesteps concurrently in the memory. If not enough memory is available use the operators trend and subtrend.
}

