% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quorum.R
\name{apply_quorum}
\alias{apply_quorum}
\title{Apply quorum to votes vector or matrix}
\usage{
apply_quorum(votes, quorum)
}
\arguments{
\item{votes}{votes vector or votes matrix}

\item{quorum}{Depending on \code{votes}:
\itemize{
\item For a vector: Vote threshold a party must reach. Used as fraction of total
votes if less than 1 otherwise as number of votes.
\item For a matrix: List of quorum functions (created with \code{\link[=quorum_functions]{quorum_functions}})
or a logical vector with the same length as the number of \code{votes} rows.
}}
}
\value{
Vector or matrix with same dimension as \code{votes}. Parties that failed to reach the
specified quorum have their votes set to zero.
}
\description{
This quorum calculation implementation is called within \code{\link[=proporz]{proporz()}}, \code{\link[=biproporz]{biproporz()}} and
related functions. Generally, there's no need to call \code{apply_quorum} directly.
}
\examples{
# vector
(votes = c(81, 9, 10))

apply_quorum(votes, 10)

apply_quorum(votes, .11)

# matrix
(votes_matrix = matrix(c(91, 9, 199, 1), nrow = 2))

apply_quorum(votes_matrix, quorum_all(total = 0.1))

apply_quorum(votes_matrix, c(FALSE, TRUE))
}
\seealso{
\code{\link[=quorum_functions]{quorum_functions}} for more matrix examples.
}
