% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranking_matrix.R
\name{ranking_matrix}
\alias{ranking_matrix}
\title{Compute the Rankings Matrix for a vector of preferences}
\usage{
ranking_matrix(x, preferences_col = NULL, frequency_col = NULL, ...)
}
\arguments{
\item{x}{A \code{\link{preferences}} object or a \code{tibble} with a
\code{preferences}-typed column.}

\item{preferences_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> When \code{x} is a
\code{tibble}, the column containing the preferences.}

\item{frequency_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> When \code{x} is a
\code{tibble}, the column containing the frequency of the preferences. If not
provided, each row is considered to be observed a single time.}

\item{...}{Currently unused.}
}
\value{
An \eqn{N} by \eqn{M} matrix, where \eqn{N} is the number of
preferences, and \eqn{M} is the number of items.
}
\description{
Convert a set of preferences to a rankings matrix, where each preference
defines a single row in the output. The columns in the rankings matrix
give the vector or ranks assigned to the corresponding candidate.
}
\details{
For a \code{preferences} vector of length \eqn{N} with \eqn{M} items, the rankings
matrix is an \eqn{N} by \eqn{M} matrix, with element \eqn{(i, j)} being the
rank assigned to candidate \eqn{j} in the \eqn{i}th selection.
}
\examples{
x <- tibble::tribble(
  ~voter_id, ~species, ~food, ~ranking,
  1, "Rabbit", "Apple", 1,
  1, "Rabbit", "Banana", 2,
  1, "Rabbit", "Carrot", 3,
  2, "Monkey", "Banana", 1,
  2, "Monkey", "Apple", 2,
  2, "Monkey", "Carrot", 3
) |>
  long_preferences(
    food_preference,
    id_cols = voter_id,
    item_col = food,
    rank_col = ranking
  ) |>
  dplyr::pull(food_preference) |>
  ranking_matrix()

}
