% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metar_location.R
\name{metar_location}
\alias{metar_location}
\title{Get approximated airport location.}
\usage{
metar_location(x = "EPWA")
}
\arguments{
\item{x}{character vector; an airport ICAO four letters code or an IATA three letters code.}
}
\value{
a tibble with columns with an airport information as below:
\itemize{
\item ICAO code
\item IATA Code
\item Airport name
\item Longitude, in degress
\item Latitude, in degress
\item Elevation, above see elevel in meters
\item Source of information
}
}
\description{
Find approximated latitude, longitude and elevation of an airport according to
IATA, International Air Transport Association, or
ICAO, International Civil Aviation Organization, airport code. Two source of
information about airports are used. First the function search in the list of
airports available at
\url{https://ourairports.com/data/}
created by David Megginson.
If an airport cannot be found there, the second list of airports is searched, from
\url{https://weather.ral.ucar.edu/surface/stations.txt}
prepared by Greg Thompson from \cr
National Weather Service NCAR/RAP.
}
\examples{
metar_location("EPWA")
metar_location("CYUL")
metar_location("LEMD")
metar_location("NCRK")
metar_location("WAW")
metar_location("FRA")

}
