% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{.anno_ggcat}
\alias{.anno_ggcat}
\title{Heatmap annotation function for categorical data}
\usage{
.anno_ggcat(
  x,
  split_by = NULL,
  group_by,
  column,
  title,
  which = "row",
  palette,
  palcolor = NULL,
  border = TRUE,
  legend.direction,
  show_legend = TRUE,
  .plotting,
  ...
)
}
\arguments{
\item{x}{A data frame}

\item{split_by}{A character string of the column name to split the data}

\item{group_by}{A character string of the column name to group the data}

\item{column}{A character string of the column name to plot}

\item{title}{A character string to name the legend}

\item{which}{A character string specifying the direction of the annotation. Default is "row".
Other options are "column".}

\item{palette}{A character string specifying the palette of the annotation}

\item{palcolor}{A character vector of colors to override the palette}

\item{border}{A logical value indicating whether to draw the border of the annotation}

\item{legend.direction}{A character string specifying the direction of the legend. Default is "vertical".
Other options are "horizontal".}

\item{show_legend}{A logical value indicating whether to show the legend}

\item{.plotting}{A function to create the plot for each split and each group}

\item{...}{Other arguments passed to \code{ComplexHeatmap::AnnotationFunction}}
}
\description{
Heatmap annotation function for categorical data
}
\keyword{internal}
