% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{group_sort}
\alias{group_sort}
\title{Sort split by grouping predictor.}
\usage{
group_sort(x, group = NULL, decreasing = FALSE)
}
\arguments{
\item{x}{A vector to be sorted.}

\item{group}{A names list that specify the different groups to split the 
data.}

\item{decreasing}{Logical: whether or not the sort order should be 
decreasing.}
}
\value{
Indices indicating the order of vector x per group.
}
\description{
Function uses \code{\link[base]{sort.list}} to return indices
of of a vector, sorted per group.
}
\examples{
# example InsectSprays from R datasets
InsectSprays$Type <- ifelse(InsectSprays$spray \%in\% c('A','B', 'F'), 1, 2)

ind <- group_sort(InsectSprays$count, 
    group=list(Spray=InsectSprays$spray, Type=InsectSprays$Type))
InsectSprays[ind,]
InsectSprays
}
\seealso{
\code{\link[base]{sort.list}}

Other Utility functions: 
\code{\link{findAbsMin}()},
\code{\link{find_n_neighbors}()},
\code{\link{firstLetterCap}()},
\code{\link{getArrowPos}()},
\code{\link{getDec}()},
\code{\link{getRange}()},
\code{\link{getRatioCoords}()},
\code{\link{get_palette}()},
\code{\link{inch2coords}()},
\code{\link{isColor}()},
\code{\link{keepFigRatio}()},
\code{\link{list2str}()},
\code{\link{move_n_point}()},
\code{\link{orderBoxplot}()},
\code{\link{se}()},
\code{\link{sortGroups}()}
}
\author{
Jacolien van Rij
}
\concept{Utility functions}
