% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{convertFile}
\alias{convertFile}
\title{Replacing separators (for example, decimal and thousand separators).}
\usage{
convertFile(
  filename,
  symbol1 = NULL,
  symbol2 = NULL,
  newsymbol1 = "",
  newsymbol2 = "",
  sep = ";",
  newsep = NULL,
  header = TRUE,
  columns = NULL,
  outputfile = gsub("^(.*)(\\\\.)([^\\\\.]*)$", "\\\\1_new.\\\\3", filename),
  fixed.s1 = TRUE,
  fixed.s2 = TRUE,
  fixed.sep = TRUE,
  ...
)
}
\arguments{
\item{filename}{String: filename (including path if necessary) of input file.}

\item{symbol1}{String: symbol to replace by \code{newsymbol1}, for example 
decimal separator.}

\item{symbol2}{String: second symbol to replace by \code{newsymbol2}, 
for example thousand separator.}

\item{newsymbol1}{String: symbol to replace \code{symbol1}.}

\item{newsymbol2}{String: symbol to replace \code{symbol2}.}

\item{sep}{String: column separator. Could be also used to replace symbols 
in the header and data by \code{newsep}, regardless of columns.}

\item{newsep}{String: symbol to replace \code{sep}. 
Only possible when \code{columns} is set to NULL.}

\item{header}{Logical: whether or not there is header line. \code{symbol1} 
and \code{symbol2} are not replaced in the header line. Default set to TRUE.}

\item{columns}{Vector with numerical values: indices of columns in which 
symbols need to be replaced.}

\item{outputfile}{String: name of outputfile.}

\item{fixed.s1}{Logical: whether or not to treat \code{symbol1} as fixed 
text instead of regular expression. Default is set to TRUE 
(no regular expression).}

\item{fixed.s2}{Logical: whether or not to treat \code{symbol2} as fixed 
text instead of regular expression. Default is set to TRUE 
(no regular expression).}

\item{fixed.sep}{Logical: whether or not to treat \code{sep} as fixed 
text instead of regular expression. Default is set to TRUE 
(no regular expression).}

\item{...}{Additional parameters for \code{\link[utils]{read.table}} and 
\code{\link[utils]{write.table}}.}
}
\description{
Replacing separators (for example, decimal and thousand separators).
}
\examples{
\dontrun{
# normally, the function call would look something like this:
convertFile('example1.csv', symbol1=',', symbol2='.', sep='\t', 
    newsymbol1='.', newsymbol2='')
# But as we are not sure that the file example1.csv is available,
# we need to do something a little more complicated to point to 
# the file 'example1.csv' that comes with the package:

# finding one of the example files from the package:
file1 <- system.file('extdata', 'example1.csv', package = 'plotfunctions')

# example 1: 
system.time({
    convertFile(file1, symbol1=',', symbol2='.', 
    newsymbol1='.', newsymbol2='', outputfile='example1_new.csv')
})
# example 2: type 'yes' to overwrite the previous output file, 
# or specify a different filename in outputfile.
system.time({
    convertFile(file1, symbol1=',', symbol2='.', sep='\t', 
    newsymbol1='.', newsymbol2='', columns=1:2, outputfile='example1_new.csv')
})
# Example 1 takes less  time, as it does not use read.table, 
# but just reads the file as text lines. However, the column 
# version could be useful when symbols should be replaced only 
# in specific columns.
# Note that Example 2 writes the output with quotes, but this is 
# not a problem for read.table:
dat <- read.table('example1_new.csv', header=TRUE, sep='\t', 
    stringsAsFactors=FALSE)
}
}
\author{
Jacolien van Rij
}
