% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_forest_grf.R
\name{details_rand_forest_grf}
\alias{details_rand_forest_grf}
\title{Generalized random forests via grf}
\description{
The \pkg{grf} fits models that create a large number of decision
trees, each independent of the others. The final prediction uses
predictions from the individual trees and combines them.
}
\details{
For this engine, there are multiple modes: classification, regression,
and quantile regression
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{mtry}: # Randomly Selected Predictors (type: integer, default: see
below)
\item \code{trees}: # Trees (type: integer, default: 2000L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 5L)
}

\code{mtry} depends on the number of columns. If there are \code{p} predictors,
the default value of \code{mtry} is \code{min(ceiling(sqrt(p) + 20), p)}.
}

\subsection{Translation from parsnip to the original package (regression)}{

See
\href{https://grf-labs.github.io/grf/reference/regression_forest.html}{\code{?regression_forest}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rand_forest(
  mtry = integer(1),
  trees = integer(1),
  min_n = integer(1)
) |>  
  set_engine("grf") |> 
  set_mode("regression") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Random Forest Model Specification (regression)
## 
## Main Arguments:
##   mtry = integer(1)
##   trees = integer(1)
##   min_n = integer(1)
## 
## Computational engine: grf 
## 
## Model fit template:
## grf::regression_forest(X = missing_arg(), Y = missing_arg(), 
##     weights = missing_arg(), mtry = min_cols(~integer(1), x), 
##     num.trees = integer(1), min.node.size = min_rows(~integer(1), 
##         x), num.threads = 1)
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (classification)}{

See
\href{https://grf-labs.github.io/grf/reference/probability_forest.html}{\code{?probability_forest}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rand_forest(
  mtry = integer(1),
  trees = integer(1),
  min_n = integer(1)
) |> 
  set_engine("grf") |> 
  set_mode("classification") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Random Forest Model Specification (classification)
## 
## Main Arguments:
##   mtry = integer(1)
##   trees = integer(1)
##   min_n = integer(1)
## 
## Computational engine: grf 
## 
## Model fit template:
## grf::probability_forest(X = missing_arg(), Y = missing_arg(), 
##     weights = missing_arg(), mtry = min_cols(~integer(1), x), 
##     num.trees = integer(1), min.node.size = min_rows(~integer(1), 
##         x), num.threads = 1)
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (quantile regression)}{

See
\href{https://grf-labs.github.io/grf/reference/quantile_forest.html}{\code{?quantile_forest}}

When specifying \emph{any} quantile regression model, the user must specify
the quantile levels \emph{a priori}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rand_forest(
  mtry = integer(1),
  trees = integer(1),
  min_n = integer(1)
) |> 
  set_engine("grf") |> 
  set_mode("quantile regression", quantile_levels = (1:3) / 4) |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Random Forest Model Specification (quantile regression)
## 
## Main Arguments:
##   mtry = integer(1)
##   trees = integer(1)
##   min_n = integer(1)
## 
## Computational engine: grf 
## 
## Model fit template:
## grf::quantile_forest(X = missing_arg(), Y = missing_arg(), mtry = min_cols(~integer(1), 
##     x), num.trees = integer(1), min.node.size = min_rows(~integer(1), 
##     x), num.threads = 1, quantiles = quantile_levels)

## Quantile levels: 0.25, 0.5, and 0.75.
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

This method \emph{does} require qualitative predictors to be converted to a
numeric format (manually). When using parsnip, a one-hot encoding is
automatically used to do this.

If there are missing values in the predictors, the model will use
case-wise deletion to remove them.
}

\subsection{Other notes}{

By default, parallel processing is turned off. When tuning, it is more
efficient to parallelize over the resamples and tuning parameters. To
parallelize the construction of the trees within the \code{grf} model, change
the \code{num.threads} argument via \code{\link[=set_engine]{set_engine()}}.

For \code{grf} confidence intervals, the intervals are constructed using the
form \verb{estimate +/- z * std_error}. For classification probabilities,
these values can fall outside of \verb{[0, 1]} and will be coerced to be in
this range.
}

\subsection{Case weights}{

The regression and classification models enable the use of case weights.
The quantile regression mode does not.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#rand-forest-grf}{examples}
for \code{rand_forest()} with the \code{"grf"} engine.
}

\subsection{References}{

Athey, Susan, Julie Tibshirani, and Stefan Wager. “Generalized Random
Forests”. \emph{Annals of Statistics}, 47(2), 2019.
}
}
\keyword{internal}
