% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSecondStageInformation.R
\name{getSecondStageInformation}
\alias{getSecondStageInformation}
\title{Calculate the Second-stage Information}
\usage{
getSecondStageInformation(firstStagePValue, design)
}
\arguments{
\item{firstStagePValue}{First-stage p-value or p-values. Must be a numeric vector between 0 and 1.}

\item{design}{An object of class \code{TrialDesignOptimalConditionalError} created by \code{getDesignOptimalConditionalErrorFunction()}. Contains all necessary arguments to calculate the optimal conditional error function for the specified case.}
}
\value{
The second-stage information.
}
\description{
Calculate second-stage information for given first-stage p-value and design.
}
\details{
The second-stage information \eqn{I_{2}} is calculated given a first-stage p-value \eqn{p_1} as:
\deqn{I_{2}(p_1) = \frac{(\Phi^{-1}(1-\alpha_2(p_1)) + \Phi^{-1}(CP))^2}{\Delta_1^2} = \frac{\nu(\alpha_2(p_1))}{\Delta_1^2},}
where
\itemize{
\item \eqn{\alpha_2(p_1)} is the conditional error function
\item \eqn{CP} is the target conditional power
\item \eqn{\Delta_1} is the assumed treatment effect (expressed as a mean difference).
}
The conditional error is calculated according to the specification provided in the \code{design} argument.
For p-values smaller or equal to the first-stage efficacy boundary as well as p-values greater than the first-stage futility boundary,
the returned information is 0 (since the trial is ended early in both cases).
}
\examples{
design <- getDesignOptimalConditionalErrorFunction(
  alpha = 0.025, alpha1 = 0.001, alpha0 = 0.5,
  conditionalPower = 0.9, delta1 = 0.25, useInterimEstimate = FALSE,
  firstStageInformation = 40, likelihoodRatioDistribution = "maxlr"
)

getSecondStageInformation(
  firstStagePValue = c(0.05, 0.1, 0.2), design = design
)

}
\references{
Brannath, W. & Bauer, P. (2004). Optimal conditional error functions for the control of conditional power. Biometrics. https://www.jstor.org/stable/3695393
}
\seealso{
\code{\link[=getDesignOptimalConditionalErrorFunction]{getDesignOptimalConditionalErrorFunction()}}, \code{\link[=getExpectedSecondStageInformation]{getExpectedSecondStageInformation()}}, \code{\link[=getOptimalConditionalError]{getOptimalConditionalError()}}
}
