% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_informations.R
\name{plot_layout_properties}
\alias{plot_layout_properties}
\title{Slide layout properties plot}
\usage{
plot_layout_properties(
  x,
  layout = NULL,
  master = NULL,
  slide_idx = NULL,
  labels = TRUE,
  title = TRUE,
  type = TRUE,
  id = TRUE,
  cex = c(labels = 0.5, type = 0.5, id = 0.5),
  legend = FALSE
)
}
\arguments{
\item{x}{an \code{rpptx} object}

\item{layout}{slide layout name or numeric index (row index from \code{\link[=layout_summary]{layout_summary()}}. If \code{NULL} (default), it plots
the current slide's layout or the default layout (if set and there are not slides yet).}

\item{master}{master layout name where \code{layout} is located. Can be omitted if layout is unambiguous.}

\item{slide_idx}{Numeric slide index (default \code{NULL}) to specify which slide’s layout should be plotted.}

\item{labels}{if \code{TRUE} (default), adds placeholder labels (centered in \emph{red}).}

\item{title}{if \code{TRUE} (default), adds a title with the layout and master name (latter in square brackets) at the top.}

\item{type}{if \code{TRUE} (default), adds the placeholder type and its index (in square brackets)
in the upper left corner (in \emph{blue}).}

\item{id}{if \code{TRUE} (default), adds the placeholder's unique \code{id} (see column \code{id} from
\code{\link[=layout_properties]{layout_properties()}}) in the upper right corner (in \emph{green}).}

\item{cex}{List or vector to specify font size for \code{labels}, \code{type}, and \code{id}. Default is
\code{c(labels = .5, type = .5, id = .5)}. See \code{\link[graphics:text]{graphics::text()}} for details on how \code{cex} works.
Matching by position and partial name matching is supported. A single numeric value will apply to all
three parameters.}

\item{legend}{Add a legend to the plot (default \code{FALSE}).}
}
\description{
Plot slide layout properties into corresponding placeholders.
This can be useful to help visualize placeholders locations and identifiers.
\emph{All} information in the plot stems from the \code{\link[=layout_properties]{layout_properties()}} output.
See \emph{Details} section for more info.
}
\details{
The plot contains all relevant information to reference a placeholder via the \verb{ph_location_*}
function family:
\itemize{
\item \code{label}: ph label (red, center) to be used in \code{\link[=ph_location_label]{ph_location_label()}}.
\emph{NB}: The label can be assigned by the user in PowerPoint.
\item \code{type[idx]}: ph type + type index in brackets (blue, upper left) to be used in \code{\link[=ph_location_type]{ph_location_type()}}.
\emph{NB}: The index is consecutive and is sorted by ph position (top -> bottom, left -> right).
\item \code{id}: ph id (green, upper right) to be used in \code{ph_location_id()} (forthcoming).
\emph{NB}: The id is set by PowerPoint automatically and lack a meaningful order.
}
}
\examples{
x <- read_pptx()

# select layout explicitly
plot_layout_properties(x = x, layout = "Title Slide", master = "Office Theme")
plot_layout_properties(x = x, layout = "Title Slide") # no master needed if layout name unique
plot_layout_properties(x = x, layout = 1) # use layout index instead of name

# plot default layout if one is set
x <- layout_default(x, "Title and Content")
plot_layout_properties(x)

# plot current slide's layout (default if no layout is passed)
x <- add_slide(x, "Title Slide")
plot_layout_properties(x)

# specify which slide's layout to plot by index
plot_layout_properties(x, slide_idx = 1)

# change appearance: what to show, font size, legend etc.
plot_layout_properties(
  x,
  layout = "Two Content",
  title = FALSE,
  type = FALSE,
  id = FALSE
)
plot_layout_properties(x, layout = 4, cex = c(labels = .8, id = .7, type = .7))
plot_layout_properties(x, 1, legend = TRUE)
}
\seealso{
Other functions for reading presentation information: 
\code{\link{annotate_base}()},
\code{\link{color_scheme}()},
\code{\link{doc_properties}()},
\code{\link{layout_properties}()},
\code{\link{layout_summary}()},
\code{\link{length.rpptx}()},
\code{\link{slide_size}()},
\code{\link{slide_summary}()}
}
\concept{functions for reading presentation information}
