% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{reliability_window}
\alias{reliability_window}
\title{Estimate test reliability by age using a sliding window}
\usage{
reliability_window(
  data,
  age_name,
  item_variables,
  window_width,
  window_version = "step",
  min_agegroup = NULL,
  max_agegroup = NULL,
  step_agegroup = 1,
  complete.obs = TRUE
)
}
\arguments{
\item{data}{data.frame containing the item scores and age variable.}

\item{age_name}{string. Name of the age variable.}

\item{item_variables}{numeric or character vector. Column indices or names of the item variables.}

\item{window_width}{numeric. Width of the sliding window used to group individuals by age.}

\item{window_version}{string. Type of windowing:
\itemize{
\item \code{"step"} (default): Estimate reliability at fixed age intervals.
\item \code{"window_per_person"}: Estimate reliability for each individual.
}}

\item{min_agegroup}{numeric. Minimum age to include. Defaults to the floor of the minimum age in the data.}

\item{max_agegroup}{numeric. Maximum age to include. Defaults to the ceiling of the maximum age in the data.}

\item{step_agegroup}{numeric. Step size between evaluated ages. Used only when \code{window_version = "step"}.}

\item{complete.obs}{logical. If \code{TRUE} (default), uses listwise deletion; if \code{FALSE}, uses pairwise deletion.}
}
\value{
A data.frame with:
\itemize{
\item \code{rel}: Reliability estimates
\item \code{age}: Corresponding age values
\item \code{window_width}: The width of the sliding window
\item \code{window_per}: Description of age step or observation unit
}

This output can be used as the \code{datarel} argument in \code{\link[=normtable_create]{normtable_create()}}.
}
\description{
Estimates reliability across age using a sliding window approach, either at fixed age points
or per individual.
}
\examples{
invisible(data("ids_kn_data"))
rel_est <- reliability_window(
  data = ids_kn_data,
  age_name = "age_years",
  item_variables = colnames(ids_kn_data),
  window_width = 2
)

}
\references{
\insertRef{heister2024item}{normref}
}
\seealso{
\code{\link[=normtable_create]{normtable_create()}}
}
