% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.sem_outs.R
\name{print.sem_outs}
\alias{print.sem_outs}
\title{Print an \code{sem_outs}-Class Object}
\usage{
\method{print}{sem_outs}(x, max_models = 20, ...)
}
\arguments{
\item{x}{An \code{sem_outs}-class object.}

\item{max_models}{The maximum number
of models to be printed. Default
is 20.}

\item{...}{Optional arguments.
Ignored.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of
an \code{sem_outs}-class object.
}
\details{
The print method for the output
of \code{fit_many()}.
}
\examples{

library(lavaan)
dat <- dat_path_model
mod <-
"
x3 ~ a*x1 + b*x2
x4 ~ a*x1
ab := a*b
"
fit <- sem(mod, dat_path_model, fixed.x = TRUE)
mod_to_add <- get_add(fit)
out <- fit_many(mod_to_add, fit)
out
print(out, max_models = 1)

}
\seealso{
An \code{sem_outs}-class object
is generated by \code{fit_many()}.
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
