% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClust_ruspini.R
\name{mlr_tasks_ruspini}
\alias{mlr_tasks_ruspini}
\title{Ruspini Cluster Task}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskClust}.
}
\description{
A cluster task for the \link[cluster:ruspini]{cluster::ruspini} data set.
}
\section{Dictionary}{

This \link[mlr3:Task]{mlr3::Task} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link[mlr3:mlr_tasks]{mlr3::mlr_tasks} or with the associated sugar function \code{\link[mlr3:mlr_sugar]{mlr3::tsk()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("ruspini")
tsk("ruspini")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{clust}
\item Dimensions: 75x2
\item Properties: -
\item Has Missings: \code{FALSE}
\item Target: -
\item Features: \dQuote{x}, \dQuote{y}
}
}

\references{
Ruspini EH (1970).
\dQuote{Numerical methods for fuzzy clustering.}
\emph{Information Sciences}, \bold{2}(3), 319-350.
\doi{10.1016/S0020-0255(70)80056-1}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html}
\item Package \CRANpkg{mlr3data} for more toy tasks.
\item Package \CRANpkg{mlr3oml} for downloading tasks from \url{https://www.openml.org}.
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Task]{Tasks}: \link[mlr3:mlr_tasks]{mlr3::mlr_tasks}
\item \code{as.data.table(mlr_tasks)} for a table of available \link[mlr3:Task]{Tasks} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3fselect} and \CRANpkg{mlr3filters} for feature selection and feature filtering.
\item Extension packages for additional task types:
\itemize{
\item Unsupervised clustering: \CRANpkg{mlr3cluster}
\item Probabilistic supervised regression and survival analysis: \url{https://mlr3proba.mlr-org.com/}.
}
}

Other Task: 
\code{\link{TaskClust}},
\code{\link{mlr_tasks_usarrests}}
}
\concept{Task}
