% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_cv.R
\name{split_cv}
\alias{split_cv}
\title{Cross-Validation Split Generator}
\usage{
split_cv(
  split_dt,
  v = 10,
  repeats = 1,
  strata = NULL,
  breaks = 4,
  pool = 0.1,
  ...
)
}
\arguments{
\item{split_dt}{\code{list} of input datasets
\itemize{
\item Must contain \code{data.frame} or \code{data.table} elements
\item Supports multiple dataset processing
\item Cannot be empty
}}

\item{v}{The number of partitions of the data set.}

\item{repeats}{The number of times to repeat the V-fold partitioning.}

\item{strata}{A variable in \code{data} (single character or name) used to conduct
stratified sampling. When not \code{NULL}, each resample is created within the
stratification variable. Numeric \code{strata} are binned into quartiles.}

\item{breaks}{A single number giving the number of bins desired to stratify a
numeric stratification variable.}

\item{pool}{A proportion of data used to determine if a particular group is
too small and should be pooled into another group. We do not recommend
decreasing this argument below its default of 0.1 because of the dangers
of stratifying groups that are too small.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{list} of \code{data.table} objects containing:
\itemize{
\item \code{splits}: Cross-validation split objects
\item \code{train}: Training dataset subsets
\item \code{validate}: Validation dataset subsets
}
}
\description{
A robust cross-validation splitting utility for multiple datasets with advanced stratification and configuration options.
}
\details{
Advanced Cross-Validation Mechanism:
\enumerate{
\item Input dataset validation
\item Stratified or unstratified sampling
\item Flexible fold generation
\item Train-validate set creation
}

Sampling Strategies:
\itemize{
\item Supports multiple dataset processing
\item Handles stratified and unstratified sampling
\item Generates reproducible cross-validation splits
}
}
\note{
Important Constraints:
\itemize{
\item Requires non-empty input datasets
\item All datasets must be \code{data.frame} or \code{data.table}
\item Strata column must exist if specified
\item Computational resources impact large dataset processing
}
}
\examples{
# Prepare example data: Convert first 3 columns of iris dataset to long format and split
dt_split <- w2l_split(data = iris, cols2l = 1:3)
# dt_split is now a list containing 3 data tables for Sepal.Length, Sepal.Width, and Petal.Length

# Example 1: Single cross-validation (no repeats)
split_cv(
  split_dt = dt_split,  # Input list of split data
  v = 3,                # Set 3-fold cross-validation
  repeats = 1           # Perform cross-validation once (no repeats)
)
# Returns a list where each element contains:
# - splits: rsample split objects
# - id: fold numbers (Fold1, Fold2, Fold3)
# - train: training set data
# - validate: validation set data

# Example 2: Repeated cross-validation
split_cv(
  split_dt = dt_split,  # Input list of split data
  v = 3,                # Set 3-fold cross-validation
  repeats = 2           # Perform cross-validation twice
)
# Returns a list where each element contains:
# - splits: rsample split objects
# - id: repeat numbers (Repeat1, Repeat2)
# - id2: fold numbers (Fold1, Fold2, Fold3)
# - train: training set data
# - validate: validation set data
}
\seealso{
\itemize{
\item \code{\link[rsample:vfold_cv]{rsample::vfold_cv()}} Core cross-validation function
}
}
