% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{atoms}
\alias{atoms}
\title{A tibble containing the NIST standard atomic weights}
\format{
\subsection{\code{atoms}}{

A data frame with 442 rows and 7 columns:
\describe{
\item{Number}{The atomic number of the element in the periodic table.}
\item{Element}{The element.}
\item{Isotope}{The mass number of the specific isotope.}
\item{Symbol}{The atomic symbol. Either only the letter (for standard isotopes) or the mass number followed by the symbol (for special isotopes).}
\item{Weight}{The monoisotopic mass of the isotope.}
\item{Composition}{The fraction of the isotope in the naturally occuring element.}
\item{Standard_Weight}{The standard atomic weight of the element. It is the sum of the product of the \code{Weight} and \code{Composition} column for each element. Where no composition is available, the weight of the IUPAC "ATOMIC WEIGHTS OF THE ELEMENTS 2023" table was used. See the Source section for more information.}
...
}
}
}
\source{
The table was retrieved from the National Institute of Standards and Technology (NIST) at https://physics.nist.gov/cgi-bin/Compositions/stand_alone.pl, accesed in October 2025, and enriched with data from the IUPAC "ATOMIC WEIGHTS OF THE ELEMENTS 2023" table at https://iupac.qmul.ac.uk/AtWt/, accesed in October 2025
}
\usage{
atoms
}
\description{
The data set contains the atomic weights of the elements and their isotopes.
It is used to calculate the exact mass in \code{\link[metamorphr]{formula_to_mass}} but can also be used as a reference.

description
}
\keyword{datasets}
