% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{residuals.logitr}
\alias{residuals.logitr}
\title{Extract Model Residuals}
\usage{
\method{residuals}{logitr}(object, fitted = NULL, ...)
}
\arguments{
\item{object}{is an object of class \code{logitr} (a model estimated using
the 'logitr()` function).}

\item{fitted}{Fitted values for an object of class \code{logitr} to use in
computing residuals. Defaults to \code{NULL}.}

\item{...}{further arguments.}
}
\value{
A data frame of the \code{obsID} and the residuals (response minus fitted
values) extracted from \code{object}.
}
\description{
Returns model residuals from an object of class \code{logitr}.
}
\examples{
library(logitr)

# Estimate a preference space model
mnl_pref <- logitr(
  data    = yogurt,
  outcome = "choice",
  obsID   = "obsID",
  pars    = c("price", "feat", "brand")
)

# Extract the residuals from the model
residuals(mnl_pref)
}
\keyword{logitr}
\keyword{resid}
\keyword{residuals}
