% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe_consistency_linter.R
\name{pipe_consistency_linter}
\alias{pipe_consistency_linter}
\title{Pipe consistency linter}
\usage{
pipe_consistency_linter(pipe = c("|>", "\%>\%", "auto"))
}
\arguments{
\item{pipe}{Which pipe operator is valid (either \code{"\%>\%"} or \code{"|>"}). The default
is the native pipe (\verb{|>}). \code{"auto"} will instead
only enforce consistency, i.e., that in any given file there is only one pipe.}
}
\description{
Check that the recommended pipe operator is used, or more conservatively that
pipes are consistent by file.
}
\examples{
# will produce lints
lint(
  text = "1:3 |> mean() \%>\% as.character()",
  linters = pipe_consistency_linter()
)

lint(
  text = "1:3 \%>\% mean() \%>\% as.character()",
  linters = pipe_consistency_linter("|>")
)

# okay
lint(
  text = "1:3 |> mean() |> as.character()",
  linters = pipe_consistency_linter()
)

lint(
  text = "1:3 \%>\% mean() \%>\% as.character()",
  linters = pipe_consistency_linter("\%>\%")
)
}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/pipes.html#magrittr}
}
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
