% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_demographicFunctions.R
\name{mxt}
\alias{mxt}
\title{Central mortality rate}
\usage{
mxt(object, x, t)
}
\arguments{
\item{object}{a \code{lifetable} or \code{actuarialtable} object}

\item{x}{subject's age}

\item{t}{period on which the rate is evaluated}
}
\value{
A numeric value representing the central mortality rate between age \eqn{x} and \eqn{x+t}.
}
\description{
This function returns the central mortality rate demographic function.
}
\examples{
#assumes SOA example life table to be load
data(soaLt)
soa08Act=with(soaLt, new("actuarialtable",interest=0.06,x=x,lx=Ix,name="SOA2008"))
#compare mx and qx 
mxt(soa08Act, 60,10)
qxt(soa08Act, 60,10)
}
\references{
Actuarial Mathematics (Second Edition), 1997, by Bowers, N.L., Gerber, H.U., Hickman, J.C., Jones, D.A. and Nesbitt, C.J.
}
