% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lev-distance.R
\name{lev_partial_ratio}
\alias{lev_partial_ratio}
\title{Ratio of the best-matching substring}
\usage{
lev_partial_ratio(a, b, pairwise = TRUE, useNames = TRUE, ...)
}
\arguments{
\item{a, b}{The input strings}

\item{pairwise}{Boolean. If \code{TRUE}, only the pairwise distances between \code{a} and \code{b} will be
computed, rather than the combinations of all elements.}

\item{useNames}{Boolean. Use input vectors as row and column names?}

\item{...}{Additional arguments to be passed to \code{\link[stringdist:stringdist]{stringdist::stringdistmatrix()}} or
\code{\link[stringdist:stringsim]{stringdist::stringsimmatrix()}}.}
}
\value{
A numeric scalar, vector or matrix depending on the length of the inputs.
}
\description{
Find the best \code{lev_ratio()} between substrings.
}
\section{Details}{

If string \code{a} has length \code{len_a} and is shorter than string \code{b}, this function finds the highest
\code{\link[=lev_ratio]{lev_ratio()}} of all the \code{len_a}-long substrings of \code{b} (and vice versa).
}

\examples{
lev_ratio("Bruce Springsteen", "Bruce Springsteen and the E Street Band")

# Here the two "Bruce Springsteen" strings will match perfectly.
lev_partial_ratio("Bruce Springsteen", "Bruce Springsteen and the E Street Band")
}
